/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_ASSEMBLY_TESTS_H_
#define _GB2_DNA_ASSEMBLY_TESTS_H_

#include <QtCore/QList>

#include <test_framework/xmltest/XMLTestUtils.h>
#include <core_api/GUrl.h>

namespace GB2 {

class DnaAssemblyMultiTask;
class MAlignmentObject;
class DNASequenceObject;

class GTest_DnaAssemblyToReferenceTask : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_DnaAssemblyToReferenceTask, "test-dna-assembly-to-ref");
    void prepare();
    Task::ReportResult report();
private:
    DnaAssemblyMultiTask* assemblyMultiTask;
    QList<GUrl> shortReadUrls;
    QString objName;
    MAlignmentObject* expectedObj;
    QString algName;
    QString refSeqUrl;
};


class GB2_COREAPI_EXPORT DnaAssemblyTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};

} //namespace
#endif
