/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_ASSEMBLY_TASK_H_
#define _GB2_DNA_ASSEMBLY_TASK_H_

#include <core_api/Task.h>
#include <core_api/GUrl.h>
#include <datatype/MAlignment.h>
#include <datatype/DNASequence.h>
#include <datatype/UIndex.h>

namespace GB2 {

class GB2_COREAPI_EXPORT DnaAssemblyToRefTaskSettings {
public:
    DnaAssemblyToRefTaskSettings() {}
    QList<DNASequence> shortReads;
    GUrl refSeqUrl;
    GUrl resultFileName;
    QString algName;
    void setCustomSettings(const QMap<QString, QVariant>& settings);
    QVariant getCustomValue(const QString& optionName, const QVariant& defaultVal) const;
    void setCustomValue(const QString& optionName, const QVariant& val);
private:
    QMap<QString, QVariant> customSettings;
};

class GB2_COREAPI_EXPORT DnaAssemblyToReferenceTask : public Task {
    Q_OBJECT
public:
    DnaAssemblyToReferenceTask(const DnaAssemblyToRefTaskSettings& settings, TaskFlags flags = TaskFlags_FOSCOE);
    virtual ~DnaAssemblyToReferenceTask() {}
    const MAlignment& getResult() { return result; }
protected:
    const DnaAssemblyToRefTaskSettings& settings;
    MAlignment result;
};

class GB2_COREAPI_EXPORT DnaAssemblyToRefTaskFactory {
public:
    virtual DnaAssemblyToReferenceTask* createTaskInstance(const DnaAssemblyToRefTaskSettings& settings) = 0;
    virtual ~DnaAssemblyToRefTaskFactory() {}
};

#define DNA_ASSEMBLEY_TO_REF_TASK_FACTORY(c) \
public: \
    static const QString taskName; \
class Factory : public DnaAssemblyToRefTaskFactory { \
public: \
    Factory() { } \
    DnaAssemblyToReferenceTask* createTaskInstance(const DnaAssemblyToRefTaskSettings& s) { return new c(s); } \
};


} // GB2


#endif // _GB2_DNA_ASSEMBLEY_TASK_H_
