/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include <core_api/AppContext.h>
#include <core_api/Settings.h>
#include <cmdline/CMDLineRegistry.h>
#include <cmdline/CMDLineHelpProvider.h>

#include "GTestFrameworkComponents.h"

#include "xmltest/XMLTestFormat.h"
#include "find_algo/FindAlgorithmTestFormat.h"

namespace GB2 {

#define TR_SETTINGS_ROOT QString("test_runner/")

GTestFormatRegistry::GTestFormatRegistry() {
    formats.append(new XMLTestFormat());    
    formats.append(new FindAlgorithmTestFormat());
}

GTestFormatRegistry::~GTestFormatRegistry() {
    foreach(GTestFormat* f, formats) {
        delete f;
    }
}

bool GTestFormatRegistry::registerTestFormat(GTestFormat* f) {
    if (formats.contains(f)) {
        return false;
    }
    formats.append(f);
    return true;
}

bool GTestFormatRegistry::unregisterTestFormat(GTestFormat* f) {
    if (!formats.contains(f)) {
        return false;
    }
    formats.removeOne(f);
    return true;
}

GTestFormat* GTestFormatRegistry::findFormat(const GTestFormatId& id) {
    foreach(GTestFormat* f, formats) {
        if (f->getFormatId() == id) {
            return f;
        }
    }
    return NULL;
}


const QString TestFramework::TEST_TIMEOUT_CMD_OPTION        = "test-timeout";
bool TestFramework::helpRegistered = false;

TestFramework::TestFramework() {
    if( !helpRegistered ) {
        setTRHelpSections();
    }
    
    if( !AppContext::getSettings()->getValue( SETTINGS_FROM_FILE, false ).toBool() ) {
        setTestRunnerSettings();
    }
}

void TestFramework::setTRHelpSections() {
    assert( !helpRegistered );
    helpRegistered = true;
    
    CMDLineRegistry * cmdLineRegistry = AppContext::getCMDLineRegistry();
    assert( NULL != cmdLineRegistry );
    
    CMDLineHelpProvider * testTimeoutSectionArguments = new CMDLineHelpProvider( TEST_TIMEOUT_CMD_OPTION, "<number-of-seconds>" );
    CMDLineHelpProvider * testTimeoutSection = new CMDLineHelpProvider( TEST_TIMEOUT_CMD_OPTION, 
        GTestFormatRegistry::tr( "set timeout for tests" ) );
    
    cmdLineRegistry->registerCMDLineHelpProvider( testTimeoutSectionArguments );
    cmdLineRegistry->registerCMDLineHelpProvider( testTimeoutSection );
}

void TestFramework::setTestRunnerSettings() {
    CMDLineRegistry * cmdLineRegistry = AppContext::getCMDLineRegistry();
    assert( NULL != cmdLineRegistry );
    Settings * settings = AppContext::getSettings();
    assert( NULL != settings );
    
    // TODO: make constants TIME_OUT_VAR and NUM_THREADS
    int timeOut = cmdLineRegistry->getParameterValue( TEST_TIMEOUT_CMD_OPTION ).toInt();
    timeOut = timeOut < 0 ? TEST_TIMEOUT_DEFAULT : timeOut;
    settings->setValue( TR_SETTINGS_ROOT + "TIME_OUT_VAR", QString::number( timeOut ) );
}

}//namespace
