/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BIOSTRUCT3D_MOLECULAR_SURFACE_H_
#define _GB2_BIOSTRUCT3D_MOLECULAR_SURFACE_H_

#include <QtCore/QObject>
#include <QtCore/QVector>
#include <QtCore/QString>
#include <memory>

#include <core_api/Task.h>
#include <datatype/BioStruct3D.h>



#include "GeomUtils.h"

namespace GB2 {

template<class T> inline T sqr(const T& x) { return x*x; }


class GB2_COREAPI_EXPORT MolecularSurface {
protected:
    static const float TOLERANCE;
public:
    virtual void calculate(const QList<SharedAtom>& atoms)=0;
    virtual void calculate(const BioStruct3D& bioStruct)=0;
    const QVector<Face> &getFaces()const;
protected:
    QVector<Vector3D> vertices;
    QVector<Face> faces;
public:
    static QList<SharedAtom> findAtomNeighbors(const SharedAtom& a, const QList<SharedAtom>& atoms);
    static GeodesicSphere getAtomSurfaceDots(const SharedAtom& a);
    static bool vertexNeighboursOneOf(const Vector3D& v, const QList<SharedAtom>& atoms);
};


class GB2_COREAPI_EXPORT MolecularSurfaceCalcTask : public Task
{
    Q_OBJECT
    MolecularSurface* molSurface;
    QString typeName;
    const QList<SharedAtom> atoms;
public: 
    MolecularSurfaceCalcTask(const QString& surfaceTypeName, const QList<SharedAtom>& atoms);
    std::auto_ptr<MolecularSurface> getCalculatedSurface();
    virtual void run();
};



class GB2_COREAPI_EXPORT MolecularSurfaceFactory {
public:
    virtual MolecularSurface *createInstance()const=0;
};

} //namespace

#endif //_GB2_BIOSTRUCT3D_MOLECULAR_SURFACE_H_

