/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_FASTQ_FORMAT_H_
#define _GB2_FASTQ_FORMAT_H_

#include <core_api/DocumentFormats.h>
#include <core_api/DocumentModel.h>
#include <QtCore/QStringList>

namespace GB2 {

class IOAdapter;

class GB2_COREAPI_EXPORT FastqFormat : public DocumentFormat {
    Q_OBJECT
public:
    FastqFormat(QObject* p);

    virtual DocumentFormatId getFormatId() const {return BaseDocumentFormats::FASTQ;}

    virtual const QString& getFormatName() const {return fn;}
    
    virtual Document* loadDocument(IOAdapter* io, TaskStateInfo& ti, const QVariantMap& fs, DocumentLoadMode mode = DocumentLoadMode_Whole);
    
    virtual void storeDocument( Document* d, TaskStateInfo& ts, IOAdapter* io );

    virtual bool checkRawData(const QByteArray& rawData) const;

private:
    QString fn;
};

}//namespace

#endif
