/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_REMOTE_MACHINE_MONITOR_H_
#define _GB2_REMOTE_MACHINE_MONITOR_H_

#include <QtCore/QList>
#include <QtCore/QVariant>

#include <core_api/core_api.h>
#include <distributed_computing/RemoteMachine.h>

namespace GB2 {

struct RemoteMachineMonitorItem {
    RemoteMachineSettings * machine;
    bool                    selected; /* if selected - it will be selected in RemoteMachineMonitorDilaog by default */
    
    RemoteMachineMonitorItem( RemoteMachineSettings * s, bool se ) 
        : machine( s ), selected( se ) {
        assert( NULL != machine );
    }
    
    RemoteMachineMonitorItem() 
        : machine( NULL ), selected( false ) {
    }
    
}; // RemoteMachineMonitorItem

/*
 * Stores all RemoteMachines that were chosen by user to use.
 * Can be accessed by AppContext::getRemoteMachineMonitor()
 */
class GB2_COREAPI_EXPORT RemoteMachineMonitor {
public:
    static const QString REMOTE_MACHINE_MONITOR_SETTINGS_TAG;
    
public:
    RemoteMachineMonitor();
    ~RemoteMachineMonitor();
    /* RemoteMachineMonitor takes ownership of this machine */
    bool addMachine( RemoteMachineSettings * machine, bool selected );
    void removeMachine( RemoteMachineSettings * machine );
    void setSelected( RemoteMachineSettings * machine, bool selected );
    
    QList< RemoteMachineSettings * > getMachinesList(); /* function not const because we can call initialize() here */
    QList< RemoteMachineMonitorItem > getRemoteMachineMonitorItems();
    QList< RemoteMachineSettings* > getSelectedMachines();
    
private:
    RemoteMachineMonitor( const RemoteMachineMonitor & );
    RemoteMachineMonitor & operator=( const RemoteMachineMonitor & );
    
    QVariant serializeMachines() const;
    bool deserializeMachines( const QVariant & data );
    
    void initialize();
    bool hasMachineInMonitor( RemoteMachineSettings * machine ) const;
    
private:
    QList< RemoteMachineMonitorItem >   items;
    bool                                initialized;
    
}; // RemoteMachineMonitor

} // GB2

#endif // _GB2_REMOTE_MACHINE_MONITOR_H_
