/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_LOCAL_TASK_MANAGER_H_
#define _GB2_LOCAL_TASK_MANAGER_H_

#include <QtCore/QUuid>
#include <QtCore/QList>
#include <QtCore/QTimer>

#include <core_api/Task.h>

#include <distributed_computing/RemoteTaskError.h>

namespace GB2 {

/*
 * Manages LocalTasks. Can be accessed by AppContext::getLocalTaskManager()
 */
class GB2_COREAPI_EXPORT LocalTaskManager : QObject {
    Q_OBJECT
public:
    static const QString TASK_WITH_GIVEN_ID_NOT_FOUND;
    static const int DELETE_TASK_UPDATE_TIME; /* every second we monitor if tasks are ready to delete */
    static const int TASK_SECONDS_TO_LIVE; /* after this time task automatically deleted */
    
public:
    static QUuid getUuid();
    static QStringList getServicesList();
    static QString getHostName();
    
public:
    LocalTaskManager();
    ~LocalTaskManager();
    
    RemoteTaskError runTask( const QString & taskFactoryId, const QVariant & settings, qint64 * taskId );
    RemoteTaskError cancelTask( qint64 taskId );
    RemoteTaskError deleteTask( qint64 taskId );
    RemoteTaskError getTaskCancelFlag( qint64 taskId, bool * cancelFlag ) const;
    RemoteTaskError getTaskState( qint64 taskId, Task::State * state ) const;
    RemoteTaskError getTaskProgress( qint64 taskId, int * progress ) const;
    RemoteTaskError getTaskResult( qint64 taskId, QVariant * result ) const;
    RemoteTaskError getTaskError( qint64 taskId, QString * errMsg ) const;
    
    QList<qint64> getTasks()const;
    
private slots:
    void sl_taskStateChanged();
    void sl_deleteTaskTimerUpdate();
    
private:
    LocalTaskManager( const LocalTaskManager & );
    LocalTaskManager & operator=( const LocalTaskManager & );
    void deleteTask( Task * task );
    Task * getTaskById( qint64 id ) const;
    
private:
    // uuid - unique number of this UGENE instance. Generated at UGENE startup
    static const QUuid      uuid;
    QMap< qint64, Task* >   allTasks;
    QMap< Task*, int >      tasksToDel; /* task and estimating time for deletion */
    QList< Task* >          deletedTasks;
    QTimer                  deleteTasksTimer;
    
}; // LocalTaskManager

} // GB2

#endif // _GB2_LOCAL_TASK_MANAGER_H_
