/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ResourceTracker.h"

#include "Log.h"
#include "Task.h"

namespace GB2 {

static LogCategory log(ULOG_CAT_USER_INTERFACE);

ResourceTracker::~ResourceTracker() {
    assert(resMap.isEmpty());
}


void ResourceTracker::registerResourceUser(const QString& resourceName, Task* t) {
    TList list = resMap.value(resourceName);
    assert(!list.contains(t));
    list.append(t);
    resMap[resourceName] = list;
    log.details(tr("resource_use %1 by %2").arg(resourceName).arg(t->getTaskName()));
    emit si_resourceUserRegistered(resourceName, t);
}
    


void ResourceTracker::unregisterResourceUser(const QString& resourceName, Task* t) {
    assert(resMap.contains(resourceName));
    TList list = resMap.value(resourceName);
    assert(list.contains(t));
    list.removeOne(t);
    if (list.isEmpty()) {
        resMap.remove(resourceName);
    } else {
        resMap[resourceName] = list;
    }
    log.details(tr("resource_release %1 by %2").arg(resourceName).arg(t->getTaskName()));
    emit si_resourceUserUnregistered(resourceName, t);
}


QList<Task*> ResourceTracker::getResourceUsers(const QString& resourceName) {
    QList<Task*> res = resMap.value(resourceName);
    return res;
}




} //namespace
