/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CMDLINE_TESTS_H_
#define _GB2_CMDLINE_TESTS_H_

#include <QtCore/QProcess>
#include <test_framework/xmltest/XMLTestUtils.h>

namespace GB2 {

/***********************************
 * arguments for cmdline ugene are set in the following way:
 * tag="value" -> --tag=value
 * if value is existing file in _common_data we will resolve this
 * if you want to place file in _tmp you should write filename as "!tmp_out!filename"
 ***********************************/
class GTest_RunCMDLine : public GTest {
    Q_OBJECT
public:
    static const QString UGENECL_PATH;
    static const QString TMP_DATA_DIR_PREFIX;
    static const QString COMMON_DATA_DIR_PREFIX;
    
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY( GTest_RunCMDLine, "run-cmdline" );
    virtual void prepare();
    virtual ReportResult report();
    virtual void cleanup();
    
private:
    void setUgeneclPath();
    void setArgs( const QDomElement & owner );
    QString getVal( const QString & val );
    
private:
    QString expectedMessage;
    QStringList args;
    QProcess *  proc;
    QString     ugeneclPath;
    
}; // GTest_RunCMDLine

class CMDLineTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
}; // CMDLineTests

} // GB2

#endif // _GB2_CMDLINE_TESTS_H_
