/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CMD_LINE_REGISTRY_
#define _GB2_CMD_LINE_REGISTRY_

#include "core_api/core_api.h"

#include <QtCore/QStringList>
#include <QtCore/QMap>

namespace GB2 {

class CMDLineHelpProvider;

typedef QPair<QString, QString> StringPair;

/*  Reads command arguments into UGENE's command line parameters 
    
    Convention:
    --paramName=paramValue -> (paramName, paramValue)
    -paramName paramValue -> (paramName, paramValue)
    paramValue1 paramValue2  -> ("", paramValue1), ("", paramValue2)
*/
class GB2_COREAPI_EXPORT CMDLineRegistry : public QObject {
    Q_OBJECT
public:
    CMDLineRegistry(const QStringList& arguments);
    virtual ~CMDLineRegistry();
    
    const QList<StringPair> & getParameters() const;
    // as they were in cmdline. Empty keys also here
    QStringList getOrderedParameterNames() const;
    
    // finding starts at startsWithIdx
    bool hasParameter( const QString & paramName, int startsWithIdx = 0 ) const;
    // returns value of first appearance from startWithIdx of paramName key
    QString getParameterValue( const QString & paramName, int startWithIdx = 0 ) const;
    
    void registerCMDLineHelpProvider(CMDLineHelpProvider* provider);
    void unregisterCMDLineHelpProvider(CMDLineHelpProvider* provider);
    
    void dumpHelp() const;
    // for debug uses only
    void dumpParameters() const;
    
public slots:
    void sl_dumpHelp();

private:
    void dumpProgramNameAndUsage() const;
    void dumpSectionName( const QString & name ) const;
    void dumpSectionContent( const QString & content ) const;
    void dumpSectionIndent() const;
    
private:
    QList<StringPair>                   params; // pairs (paramName, paramValue) ordered as in the cmdline
    QList<CMDLineHelpProvider* >        helpProviders; // sorted by section name
    
}; // CMDLineRegistry

} //namespace GB2

#endif // _GB2_CMD_LINE_REGISTRY_
