/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PROJECT_TASKS_H_
#define _GB2_PROJECT_TASKS_H_

#include <QUrl>

#include <core_api/Task.h>
#include <core_api/ProjectModel.h>

class QDomDocument;


namespace GB2 {

class Project;
class StateLock;

/// CloseProjectTask schema:
//	->CloseProjectTask (serial subtasks):
//		->SaveProjectTask
//		->UnregisterProjectTask	
class CloseProjectTask : public Task {
    Q_OBJECT

public:
	CloseProjectTask();
	virtual void prepare();
};


/// OpenProjectTask schema:
//	->OpenProjectTask (serial subtasks):
//		->CloseProjectTask
//		->LoadProjectTask
//		->RegisterProjectTask (added after LoadProjectTask is successfully finished)

class LoadProjectTask;
class OpenProjectTask : public Task {
    Q_OBJECT

public:
	OpenProjectTask(const QString& url, bool closeActiveProject, const QString& name = QString::null);
    OpenProjectTask(const QList<QUrl>& list, bool closeActiveProject);
	
	virtual void prepare();
	
protected:
	virtual QList<Task*> onSubTaskFinished(Task* subTask);

private:
	QString url;
	QString name;
    QList<QUrl> urlList;
	LoadProjectTask* loadProjectTask;
    bool closeActiveProject;
};

class OpenProjectTaskAndExecDialog : public OpenProjectTask {
    Q_OBJECT

public:
    OpenProjectTaskAndExecDialog(QDialog *_dialog);
    Task::ReportResult report();
private:
    QDialog *dialog;
};


/// SaveProjectTask schema:
//	->SaveProjectTask
//		->SaveDocumentsTask
class SaveProjectTask : public Task {
    Q_OBJECT

public:
    SaveProjectTask(SaveProjectTaskKind k, Project* p = NULL, const QString& url = QString::null);
    ~SaveProjectTask();

    virtual void prepare();
    ReportResult report();

private:
    SaveProjectTaskKind k;
    Project* proj;
    QString url;
};

class SaveOnlyProjectTask : public Task {
    Q_OBJECT
public:
    SaveOnlyProjectTask(Project* p = NULL, const QString& url = QString::null);
    ~SaveOnlyProjectTask();

    virtual void prepare();
    ReportResult report();
private:
    void saveProjectFile(TaskStateInfo& ts, Project* p, QString url);
    QList<Task*> onSubTaskFinished(Task* subTask);
    void _run();

    Task *sub;
    Project* proj;
    QString url;
    StateLock* lock;
    QList<Document*> phantomDocs;
};


/// LoadProjectTask
class LoadProjectTask : public Task {
    Q_OBJECT

public:
	LoadProjectTask(const QString& url);
	~LoadProjectTask();

	virtual void run();
	ReportResult report();

	Project* getProject() const {return proj;}
	Project* detachProject() {Project* tmp = proj; proj = NULL; return tmp;}

	static void loadXMLProjectModel(const QString& url, TaskStateInfo& si, QDomDocument& doc);
	static Project* createProjectFromXMLModel(const QString& url, const QDomDocument& xmlDoc, TaskStateInfo& si);

private:
	Project* proj;
	QString url;
	QDomDocument* xmlDoc;
};


/// register project task
//TODO: remove service+plugin binding -> add 'singleton' property to service. After its done this task will not be needed

class RegisterProjectServiceTask : public Task {
    Q_OBJECT
public:
    RegisterProjectServiceTask(Project* proj);
    void prepare();
private:
    Project* proj;
};

}//namespace

#endif
