/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef m_params_h
#define m_params_h

#include "mx.h"
#include "seqdb.h"


typedef float (*FWD_BWD)(Mx<float> &PPf);

#define T(x)	extern float Trans##x;
#include "transparams.h"

void SetSimMx(SeqDB &DB, unsigned IdA, unsigned IdB);
Mx<float> &GetSubstMxf();
Mx<float> &GetSimMxf();

float **GetSubstMx();
float **GetSimMx();
void LogParams();
void LogModelParams();
void MaskSubstMx();

void SetHOXD55();
void SetHOXD70();
void SetPCCRFMX();
void SetPCRNA();
void SetBLOSUM70C();

const string &GetModel();
void GetLocalModel(SeqDB &DB, string &Model);
FWD_BWD SetModel(const string &Model);

struct AlgoFwdBwdData
	{
	string Algo;
	string FwdBwdName;
	FWD_BWD FwdBwd;
	};

struct AlgoTransData
	{
	string Algo;
	string Trans;
	float *Address;
	};

struct ModelAlgoData
	{
	string Model;
	string Algo;
	};

struct ModelOptTransData
	{
	string Model;
	string Opt;
	string Trans;
	};

struct ModelOptDefaultHelpData
	{
	string Model;
	string Opt;
	float Default;
	string Help;
	};

struct OptData
	{
	string Name;
	double *Address;
	};


#endif // transparams_h
