/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "mx.h"
#include "params.h"
#include "sumlog.h"
#include "Muscle4TaskLocalStorage.h"

//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

//Mx<float> g_SubstMxf;

#define T(x)	float Trans##x;
#include "transparams.h"

Mx<float> &GetSubstMxf()
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	return ctx->g_SubstMxf;
	}

float **GetSubstMx()
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	asserta(ctx->g_SubstMxf.m_RowCount == 256 && ctx->g_SubstMxf.m_ColCount == 256);
	MaskSubstMx();
	return ctx->g_SubstMxf.GetData();
	}

void LogSubstMx()
	{
	GetSubstMxf().LogMe();
	}

void LogParams()
	{
	/*Log("\n");
	Log("Model=%s\n", GetModel().c_str());

#define T(x)	if (Trans##x != LOG_ZERO) Log(#x " = %g\n", Trans##x);
#include "transparams.h"

	g_SubstMxf.LogMe(); */
	}

void MaskSubstMx()
	{
	GB2::Muscle4Context *ctx = getMuscle4Context();
	float **M = ctx->g_SubstMxf.GetData();
	if (!ctx->opt_mask || M[(byte) 'a'][(byte) 'a'] == 0)
		return;
	for (unsigned i = 0; i < 256; ++i)
		{
		for (unsigned j = 0; j < 256; ++j)
			{
			if (islower(i) || islower(j))
				M[i][j] = 0;
			}
		}
	}
