/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "sumlog.h"
#include "params.h"
#include "mx.h"
#include "seqdb.h"
#include "Muscle4TaskLocalStorage.h"
//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

//#define		m(x)	static Mx<float> g_Fwd##x;
//static Mx<float> g_FwdM4;
//static Mx<float> g_FwdD4;
//static Mx<float> g_FwdI4;
//	m(M)
//	m(D)
//	m(I)
//#undef m

void FwdSWCRF()
	{
	Mx<float> &Simf = GetSimMxf();
	GB2::Muscle4Context *ctx = getMuscle4Context();
	const float * const *SimMx = Simf.GetData();

	const unsigned LA = Simf.m_RowCount - 1;
	const unsigned LB = Simf.m_ColCount - 1;

#define		m(x)	ctx->g_Fwd##x.Alloc("SWCRF_Fwd"#x, LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);	 \
					float **Fwd##x = ctx->g_Fwd##x.GetData();
	m(M4)
	m(D4)
	m(I4)
#undef m

	for (unsigned i = 0; i <= LA; ++i)
		{
		FwdM4[i][0] = LOG_ZERO;
		FwdD4[i][0] = LOG_ZERO;
		FwdI4[i][0] = LOG_ZERO;
		}

	for (unsigned j = 0; j <= LB; ++j)
		{
		FwdM4[0][j] = LOG_ZERO;
		FwdD4[0][j] = LOG_ZERO;
		FwdI4[0][j] = LOG_ZERO;
		}

// Main loop
	for (unsigned i = 0; i < LA; ++i)
		{
		const float *SimMxRow = SimMx[i+1];
		for (unsigned j = 0; j < LB; ++j)
			{
		// xM
			{
			float Match = SimMxRow[j+1];
			float MM = FwdM4[i][j];
			float DM = FwdD4[i][j];
			float IM = FwdI4[i][j];
			float SM = 0;
			FwdM4[i+1][j+1] = SumLog4(MM, DM, IM, SM) + Match;
			}
			
		// xD
			{
			float MD = FwdM4[i][j+1] + ctx->TransMD;
			float DD = FwdD4[i][j+1] + ctx->TransDD;
			FwdD4[i+1][j+1] = SumLog2(MD, DD);
			}
			
		// xI
			{
			float MI = FwdM4[i+1][j] + ctx->TransMI;
			float II = FwdI4[i+1][j] + ctx->TransII;
			FwdI4[i+1][j+1] = SumLog2(MI, II);
			}
			}
		}
	}
