/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "best.h"
#include "mx.h"
#include "sumlog.h"
#include "seqdb.h"
#include "params.h"
//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

void FwdSWCRF();
void BwdSWCRF();

float FwdBwdSWCRF(Mx<float> &PPMx)
	{
	Mx<float> &Simf = GetSimMxf();

	const unsigned LA = Simf.m_RowCount - 1;
	const unsigned LB = Simf.m_ColCount - 1;

	FwdSWCRF();
	BwdSWCRF();

#define m(x)	float **x = MxBase::Getf("SWCRF_"#x);
	m(FwdM4)
	m(BwdM6)
#undef m

	PPMx.Alloc("SWCRF_PP", LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);
	float **PP = PPMx.GetData();

	float TotalScore = LOG_ZERO;
	for (unsigned i = 1; i <= LA; ++i)
		for (unsigned j = 1; j <= LB; ++j)
			TotalScore = SumLog2(TotalScore, FwdM4[i][j]);

	TotalScore = SumLog2(TotalScore, 0);

	for (unsigned i = 0; i <= LA; ++i)
		PP[i][0] = 0;
	for (unsigned j = 0; j <= LB; ++j)
		PP[0][j] = 0;

	for (unsigned i = 1; i <= LA; ++i)
		{
		for (unsigned j = 1; j <= LB; ++j)
			{
			float Score = FwdM4[i][j] + BwdM6[i][j];
			float LogProb = Score - TotalScore;
			float Prob = EXP(LogProb);
			//if (Prob < -0.1f || Prob > 1.1f)
			//	Warning("Prob=%g", Prob);

			PP[i][j] = Prob;
			}
		}

	return TotalScore;
	}
