/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
#include "best.h"
#include "mx.h"
#include "sumlog.h"
#include "seqdb.h"
#include "params.h"
#include "Muscle4TaskLocalStorage.h"
//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

void FwdFull();
void BwdFull();

float FwdBwdFull(Mx<float> &PPMx)
	{
	Mx<float> &Simf = GetSimMxf();
	
	const unsigned LA = Simf.m_RowCount - 1;
	const unsigned LB = Simf.m_ColCount - 1;

	FwdFull();
	BwdFull();

#define m(x)	float **x = MxBase::Getf("Full_"#x);
	m(FwdM7)
	m(FwdD7)
	m(FwdI7)
	m(FwdX7)
	m(FwdY7)
	m(BwdM5)
	m(BwdD5)
	m(BwdI5)
	m(BwdX5)
	m(BwdY5)
#undef m

	PPMx.Alloc("Full_PP", LA+1, LB+1, Simf.m_SeqDB, Simf.m_IdA, Simf.m_IdB);
	float **PP = PPMx.GetData();

	float TotalScore = SumLog5(
	  FwdM7[LA][LB] + BwdM5[LA][LB],
	  FwdD7[LA][LB] + BwdD5[LA][LB],
	  FwdI7[LA][LB] + BwdI5[LA][LB],
	  FwdX7[LA][LB] + BwdX5[LA][LB],
	  FwdY7[LA][LB] + BwdY5[LA][LB]);

	for (unsigned i = 0; i <= LA; ++i)
		PP[i][0] = 0;
	for (unsigned j = 0; j <= LB; ++j)
		PP[0][j] = 0;

	for (unsigned i = 1; i <= LA; ++i)
		{
		for (unsigned j = 1; j <= LB; ++j)
			{
			float Score = FwdM7[i][j] + BwdM5[i][j];
			float LogProb = Score - TotalScore;
			float Prob = EXP(LogProb);
			//if (Prob < -0.1f || Prob > 1.1f)
			//	Warning("Prob=%g", Prob);

			PP[i][j] = Prob;
			}
		}

	return TotalScore;
	}
