/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MUSCLE_TESTS_H_
#define _GB2_MUSCLE_TESTS_H_

#include <test_framework/xmltest/XMLTestUtils.h>
#include <core_api/GObject.h>
#include <QtXml/QDomElement>
#include <QFileInfo>

#include "Muscle4Task.h"

namespace GB2 {

class MuscleGObjectTask;
class MAlignmentObject;
class LoadDocumentTask;
class MAlignment;

class GTest_muscle4 : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_muscle4, "umuscle4");
    
    void prepare();
    Task::ReportResult report();
    void cleanup();

private:    
    QString inputDocCtxName;
    QString resultCtxName;
    Document* doc;
    Muscle4GObjectTask* mTask;
    MAlignmentObject *ma_result;
    bool ctxAdded;
    bool refineOnly;
    int maxIters;
    bool alignRegion;
    LRegion region;
    bool stable;
};

class GTest_CompareMAlignment : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_CompareMAlignment, "compare-malignment4");

    Task::ReportResult report();

private:    
    QString doc1CtxName;
    QString doc2CtxName;
};

class GTest_Muscle4AddUnalignedSequenceToProfile: public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_Muscle4AddUnalignedSequenceToProfile, "muscle4-add-unaligned-seq-to-profile");

    void prepare();
    Task::ReportResult report();

private:    
    QString                 aliDocName;
    QString                 seqDocName;
    int                     resultAliLen;
    QList< QList<int> >     gapPositionsForSeqs;
    MAlignmentObject*       aliObj;
    int                     origAliSeqs;
    int                     resultAliSeqs;
};

class  Muscle4_Load_Align_Compare_Task : public Task {
    Q_OBJECT
public:
    Muscle4_Load_Align_Compare_Task(QString inFileURL, QString patFileURL, Muscle4TaskSettings& config, QString _name = QString("Muscle_4_Load_Align_Compare_Task"));
    ~Muscle4_Load_Align_Compare_Task() {cleanup();}
    void prepare();
    void run();
    QList<Task*> onSubTaskFinished(Task* subTask);
    ReportResult report();
    void cleanup();

public slots:
    void sl_muscleProgressChg() {stateInfo.progress = muscleTask->getProgress();}

private:
    MAlignment dna_to_ma(QList<GObject*> dnaSeqs);
    QString str_inFileURL;
    QString str_patFileURL;
    LoadDocumentTask*           loadTask1;
    LoadDocumentTask*           loadTask2;
    Muscle4Task*         muscleTask;
    Muscle4TaskSettings          config;
    MAlignmentObject*           ma1;
    MAlignmentObject*           ma2;

};

class GTest_Muscle4_Load_Align_Compare: public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_Muscle4_Load_Align_Compare, "muscle4-load-align-compare");
    void prepare();
    Task::ReportResult report();
private:
    QString inFileURL;
    QString patFileURL;
    Muscle4_Load_Align_Compare_Task *worker;
};

class GTest_Muscle4PacketTest: public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_Muscle4PacketTest, "muscle4-packet-test");

    void prepare();
    Task::ReportResult report();

private:    
    QString                 inDirName;
    QString                 patDirName;
    QTime                   timer;
};

class  Muscle4Tests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};
}//namespace
#endif
