/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MUSCLE_TASK_H_
#define _GB2_MUSCLE_TASK_H_

#include <core_api/Task.h>
#include <gobjects/MAlignmentObject.h>
#include "Muscle4Plugin.h"

#include <QtCore/QPointer>

class Muscle4Context;

namespace GB2 {

class StateLock;
class MAlignmentObject;
class LoadDocumentTask;
//class MuscleParallelTask;

enum Muscle4TaskOp {
    Muscle4TaskOp_Align,
    Muscle4TaskOp_Refine,
    Muscle4TaskOp_AddUnalignedToProfile,
    Muscle4TaskOp_ProfileToProfile
};

class Muscle4TaskSettings {
public:
    Muscle4TaskSettings() {reset();}
    void reset();

    Muscle4TaskOp    op;

    int             maxIterations;
    unsigned long   maxSecs; // 0 - unlimited
    bool            stableMode;

    //used only for MuscleTaskOp_DoAlign
    bool            alignRegion;
    LRegion         regionToAlign;

    //used only for MuscleTaskOp_AddUnalignedToProfile and MuscleTaskOp_ProfileToProfile
    MAlignment      profile;

    //number of threads: 0 - auto, 1 - serial
    int nThreads;

};

class Muscle4Task : public Task {
    Q_OBJECT
public:
    Muscle4Task(const MAlignment& ma, const Muscle4TaskSettings& config);

    void run();

    void doAlign(bool refineOnlyMode);
    void doAddUnalignedToProfile();
    void doProfile2Profile();

    ReportResult report();

    Muscle4TaskSettings          config;
    MAlignment                  inputMA;
    MAlignment                  resultMA;

    MAlignment                  inputSubMA;
    MAlignment                  resultSubMA;

    Muscle4Context*              ctx;
    //MuscleParallelTask*         parallelSubTask;
};

class Muscle4AddSequencesToProfileTask : public Task {
    Q_OBJECT
public:
    enum MMode {Profile2Profile, Sequences2Profile};
    Muscle4AddSequencesToProfileTask(MAlignmentObject* obj, const QString& fileWithSequencesOrProfile, MMode mode);

    QList<Task*> onSubTaskFinished(Task* subTask);

    ReportResult report();

    QPointer<MAlignmentObject>  maObj;
    LoadDocumentTask*           loadTask;
    MMode                       mode;
};

//locks MAlignment object and propagate MuscleTask results to it
class  Muscle4GObjectTask : public Task {
    Q_OBJECT
public:
    Muscle4GObjectTask(MAlignmentObject* obj, const Muscle4TaskSettings& config);
    ~Muscle4GObjectTask();

    virtual void prepare();
    ReportResult report();

    QPointer<MAlignmentObject>  obj;
    StateLock*                  lock;
    Muscle4Task*                 muscleTask;
    Muscle4TaskSettings          config;
};
}//namespace
#endif
