/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SITECON_PLUGIN_H_
#define _GB2_SITECON_PLUGIN_H_

#include "DIProperties.h"

#include <core_api/PluginModel.h>
#include <core_api/ObjectViewModel.h>

#include <QtGui/QMenu>

namespace GB2 {

class SiteconADVContext;
class XMLTestFactory;

class SiteconPlugin : public Plugin {
    Q_OBJECT
public:
    SiteconPlugin();
    ~SiteconPlugin();

    static QList<DiProperty*> getDinucleotiteProperties() {return dp.getProperties();}

protected slots:
    void sl_build();
    void sl_search();

private:
    SiteconADVContext*                  ctxADV;
    static DinucleotitePropertyRegistry dp;
};


class SiteconADVContext: public GObjectViewWindowContext {
    Q_OBJECT
public:
    SiteconADVContext(QObject* p);

protected slots:
    void sl_search();

protected:
    virtual void initViewContext(GObjectView* view);
};

class SiteconAlgorithmTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};

} //namespace

#endif
