/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _PRIMER3_TASK_H_
#define _PRIMER3_TASK_H_

#include <memory>

#include <core_api/Task.h>
#include <gobjects/AnnotationTableObject.h>

#include "Primer3TaskSettings.h"

#include "primer3.h"

namespace GB2 {

class Primer
{
public:
    Primer();
    Primer(const primer_rec &primerRec);

    int getStart()const;
    int getLength()const;
    double getMeltingTemperature()const;
    double getGcContent()const;
    short getSelfAny()const;
    short getSelfEnd()const;
    double getEndStabilyty()const;

    void setStart(int start);
    void setLength(int length);
    void setMeltingTemperature(double meltingTemperature);
    void setGcContent(double gcContent);
    void setSelfAny(short selfAny);
    void setSelfEnd(short selfEnd);
    void setEndStability(double endStability);
private:
    int start;
    int length;
    double meltingTemperature;
    double gcContent;
    short selfAny;
    short selfEnd;
    double endStability;
};

class PrimerPair
{
public:
    PrimerPair();
    PrimerPair(const primer_pair &primerPair);
    PrimerPair(const PrimerPair &primerPair);
    const PrimerPair &operator=(const PrimerPair &primerPair);

    Primer *getLeftPrimer()const;
    Primer *getRightPrimer()const;
    Primer *getInternalOligo()const;
    short getComplAny()const;
    short getComplEnd()const;
    int getProductSize()const;

    void setLeftPrimer(Primer *leftPrimer);
    void setRightPrimer(Primer *rightPrimer);
    void setInternalOligo(Primer *internalOligo);
    void setComplAny(short complAny);
    void setComplEnd(short complEnd);
    void setProductSize(int productSize);
private:
    // don't forget to change copy constructor and assignment operator when changing this!
    std::auto_ptr<Primer> leftPrimer;
    std::auto_ptr<Primer> rightPrimer;
    std::auto_ptr<Primer> internalOligo;
    short complAny;
    short complEnd;
    int productSize;
};

class Primer3Task : public Task
{
    Q_OBJECT
public:
    Primer3Task(const Primer3TaskSettings &settings);

    void run();
    Task::ReportResult report();

    QList<PrimerPair> getBestPairs()const;
private:
    Primer3TaskSettings settings;
    QList<PrimerPair> bestPairs;
};

class Primer3ToAnnotationsTask : public Task {
    Q_OBJECT
public:
    Primer3ToAnnotationsTask( const Primer3TaskSettings &settings,
        AnnotationTableObject* aobj_, const QString & groupName_, const QString & annName_ );

    void prepare();
    Task::ReportResult report();

private:
    SharedAnnotationData oligoToAnnotation(QString title, const Primer &primer, bool complement);

    Primer3TaskSettings settings;

    AnnotationTableObject * aobj;
    QString groupName;
    QString annName;

    Primer3Task *searchTask;
};

} //namespace

#endif //_PRIMER3_TASK_H_
