/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GRAPHPACK_ENTROPY_H_
#define _GB2_GRAPHPACK_ENTROPY_H_

#include "DNAGraphPackPlugin.h"

#include <util_ov_annotated_dna/GSequenceGraphView.h>

#include <QtGui/QAction>
#include <QtCore/QList>
#include <QtCore/QBitArray>

namespace GB2 {

class AnnotatedDNAView;

class EntropyGraphFactory : public GSequenceGraphFactory {
	Q_OBJECT
public:
	EntropyGraphFactory(QObject* p);
	virtual QList<GSequenceGraphData*> createGraphs(GSequenceGraphView* v);
    virtual GSequenceGraphDrawer* getDrawer(GSequenceGraphView* v);
	virtual bool isEnabled(DNASequenceObject* o) const;
};

class EntropyGraphAlgorithm : public GSequenceGraphAlgorithm {
public:
	EntropyGraphAlgorithm();
    virtual ~EntropyGraphAlgorithm() {}

	virtual void calculate(QVector<float>& res, DNASequenceObject* o, const LRegion& r, const GSequenceGraphWindowData* d);
};

} // namespace
#endif
