/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_BUS_H_
#define _GB2_WORKFLOW_BUS_H_

#include <workflow/IntegralBusModel.h>
#include <workflow/WorkflowTransport.h>

#include <QtCore/QSet>

namespace GB2 {
namespace Workflow {

class WCOREAPI_EXPORT IntegralBus : public QObject, public CommunicationSubject, public CommunicationChannel {
    Q_OBJECT
public:
    IntegralBus(Port* peer);
    virtual bool addCommunication(const QString& id, CommunicationChannel* ch) {outerChannels.insertMulti(id, ch); return true;}
    virtual CommunicationChannel* getCommunication(const QString& id) {return outerChannels.value(id);}

    virtual Message get();
    virtual void put(const Message& m);
    virtual int hasMessage() const;
    virtual int hasRoom(const DataType* t = NULL) const;
    virtual bool isEnded() const;
    virtual void setEnded();

    virtual int capacity() const {return 1;}
    virtual void setCapacity(int) {}

    virtual QVariantMap getContext() const {return context;}
    virtual void setContext(const QVariantMap& m) {context = m;}

    virtual void addComplement(IntegralBus* b) {assert(!complement);complement = b;}

protected:
    virtual Message composeMessage(const Message&);

protected:
    DataTypePtr busType;
    QMap<QString, CommunicationChannel*> outerChannels;
    QStrStrMap busMap;
    QMap<QString, QStringList> listMap;
    QVariantMap context;
    IntegralBus* complement;
};

}//Workflow namespace
}//GB2 namespace

#endif
