/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SubstMatrixDialog.h"
#include <util_smith_waterman/SubstMatrix.h>

#include <QString>
#include <QScrollBar>
#include <QHeaderView>
#include <QTableWidgetItem>


namespace GB2 {

SubstMatrixDialog::SubstMatrixDialog(const SubstMatrix* _pSm, const QString& mtx_name):
        saveDiagEl(0), hlRow(-1), hlColumn(-1), pSm(_pSm)
{
	setupUi(this);
	setWindowTitle(mtx_name);
	connectGUI();
	hideAll();	
	drawMatrix();
}

void SubstMatrixDialog::sl_newMatrix() {
}

void SubstMatrixDialog::sl_saveMatrix() {
}

void SubstMatrixDialog::sl_closeWindow() {
	close();
}

void SubstMatrixDialog::sl_teAlphabetChanged(QString str) {
    Q_UNUSED(str);
    //todo!
}

void SubstMatrixDialog::connectGUI() {
	connect(bttnNew, SIGNAL(clicked()), SLOT(sl_newMatrix()));
	connect(bttnSave, SIGNAL(clicked()), SLOT(sl_saveMatrix()));
	connect(bttnClose, SIGNAL(clicked()), SLOT(sl_closeWindow()));
	connect(leditAlphabet, SIGNAL(textChanged(QString)), SLOT(teAlphabetChanged(QString)));

	connect(tableMatrix, SIGNAL(cellEntered(int, int)), SLOT(sl_mouseOnCell(int, int)));
	connect(tableMatrix, SIGNAL(cellChanged(int, int)), SLOT(sl_changedCell(int, int)));
}

void SubstMatrixDialog::drawMatrix() {
	if (0 == pSm) {
		return;
	}
	hlRow	 = -1;
	hlColumn = -1;	
	tableMatrix->setMouseTracking(true);
	if (0 != saveDiagEl) {
		delete[] saveDiagEl;
	}

	disconnect(tableMatrix, SIGNAL(cellChanged(int, int)), this, SLOT(sl_changedCell(int, int)));

	tableMatrix->clear();
	tableMatrix->horizontalHeader()->setHidden(true);
	tableMatrix->verticalHeader()  ->setHidden(true);

	int n = pSm->getDim();
	tableMatrix->setRowCount(n + 1);
	tableMatrix->setColumnCount(n + 1);

	saveDiagEl = new float[n];
	for (int i = 0; i < n; i++) {
		char ch_i = pSm->getKthSimbol(i);
		saveDiagEl[i] = pSm->getScore(ch_i, ch_i); 
	}

	QTableWidgetItem* ptwi = new QTableWidgetItem("");
	Qt::ItemFlags flags = ptwi->flags();
	flags &= (~Qt::ItemIsEditable);
	ptwi->setFlags(flags);
	tableMatrix->setItem(0, 0, ptwi);

	for (int i = 0; i < n; i++) {
		for (int j = 0; j < n; j++) {
			char ch_i = pSm->getKthSimbol(i);
			char ch_j = pSm->getKthSimbol(j);
			float score = pSm->getScore(ch_i, ch_j);
            ptwi = new QTableWidgetItem(QString::number(score));
			ptwi->setFlags(flags);
			tableMatrix->setItem(i + 1, j + 1, ptwi);
		}				
	}
	for (int i = 0; i < n; i++) {
		QColor color(hdr_clr_r, hdr_clr_g, hdr_clr_b);
		
		char ch = pSm->getKthSimbol(i);
		QString title(ch);

		ptwi = new QTableWidgetItem(title);		
		ptwi->setBackgroundColor(color);
		ptwi->setFlags(flags);
		tableMatrix->setItem(i+1, 0, ptwi);

		ptwi = new QTableWidgetItem(title);		
		ptwi->setFlags(flags);
		ptwi->setBackgroundColor(color);
		tableMatrix->setItem(0, i+1, ptwi);
	}

	tableMatrix->verticalHeader()  ->setResizeMode(QHeaderView::Stretch);
	tableMatrix->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
	tableMatrix->setMinimumSize(cell_width * n, cell_width * n);

	if (!tableMatrix->isEnabled()) {
		tableMatrix->setEnabled(true);
	}
	connect(tableMatrix, SIGNAL(cellChanged(int, int)), SLOT(sl_changedCell(int, int)));
}

void SubstMatrixDialog::sl_mouseOnCell(int row, int column) {
	QTableWidgetItem* pw = 0;

	QColor clr(hdr_clr_r, hdr_clr_g, hdr_clr_b);
	QColor hlclr(hlhdr_clr_r, hlhdr_clr_g, hlhdr_clr_b);

	if (row != hlRow && 0 != row) {
		if (0 != (pw = tableMatrix->item(row, 0))) {
			pw->setBackgroundColor(hlclr);
		}
		if (hlRow > 0) {
			if (0 != (pw = tableMatrix->item(hlRow, 0))) {
				pw->setBackgroundColor(clr);
			}
		}
		hlRow = row;
	}

	if (column != hlColumn && 0 != column) {
		if (0 != (pw = tableMatrix->item(0, column))) {
			pw->setBackgroundColor(hlclr);
		}
		if (hlRow > 0) {
			if (0 != (pw = tableMatrix->item(0, hlColumn))) {
				pw->setBackgroundColor(clr);
			}
		}
		hlColumn = column;
	}
}

void SubstMatrixDialog::sl_changedCell(int row, int column) {	
	QTableWidgetItem* currItem = tableMatrix->item(row, column);
	QTableWidgetItem* compItem = tableMatrix->item(column, row);
	
	if (0 == currItem || 0 == compItem) {
		return;
	}

	QString cellTitle	  = currItem->text();
	QString compCellTitle = compItem->text();
	
	bool ok = false;
	float newScore = cellTitle.toFloat(&ok);
	
	if (cellTitle != compCellTitle) {
		if (ok) {			
			compItem->setText(cellTitle);			
		} else {
			currItem->setText(compCellTitle);
		}
	} else if (row == column) {
		if (ok) {
			saveDiagEl[row] = newScore;
		} else {
            currItem->setText(QString::number(saveDiagEl[row]));
		}
	}
}

void SubstMatrixDialog::hideAll() {
	bttnNew->hide();
	bttnSave->hide();
	bttnClose->hide();

	lblAlphabet->hide();
	leditAlphabet->hide();
}

} // namespace
