/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EXPORT_SEC_STRUCT_DIALOG_H_
#define _GB2_EXPORT_SEC_STRUCT_DIALOG_H_

#include <datatype/AnnotationData.h>
#include <ui/ui_SecStructDialog.h>

namespace GB2 {

class ADVSequenceObjectContext;
class SecStructPredictTask;  
class SecStructPredcitAlgRegistry;
class Task;

class GB2_COREAPI_EXPORT SecStructDialog : public QDialog, private Ui::SecStructDialog    {
    Q_OBJECT

public:
    SecStructDialog(ADVSequenceObjectContext* ctx, QWidget *p = NULL);

private slots:
    void sl_spinRangeStartChanged(int val);
    void sl_spinRangeEndChanged(int val);
    void sl_onStartPredictionClicked();
    void sl_onTaskFinished(Task*);
    void sl_onSaveAnnotations();

private:
    int rangeStart;
    int rangeEnd;
    QList<SharedAnnotationData> results;
    ADVSequenceObjectContext* ctx;
    SecStructPredictTask* task;
    SecStructPredcitAlgRegistry* sspr;
    void connectGUI();
    void updateState();
    void showResults();
};



} // namespace

#endif //  _GB2_EXPORT_SEC_STRUCT_DIALOG_H_

