/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SimpleTextObjectViewTasks.h"
#include "SimpleTextObjectView.h"

#include <core_api/AppContext.h>
#include <core_api/DocumentFormats.h>
#include <core_api/ProjectModel.h>
#include <core_api/DocumentModel.h>
#include <gobjects/TextObject.h>

namespace GB2 {


//////////////////////////////////////////////////////////////////////////
//open view task

OpenSimpleTextObjectViewTask::OpenSimpleTextObjectViewTask(Document* _doc) 
: ObjectViewTask(SimpleTextObjectViewFactory::ID), doc(_doc)
{
    if (!doc->isLoaded()) {
        documentsToLoad.append(doc);
    }
}

OpenSavedTextObjectViewTask::OpenSavedTextObjectViewTask(const QString& vname, const QVariantMap& stateData) 
: ObjectViewTask(SimpleTextObjectViewFactory::ID, vname, stateData), doc(NULL)
{
    QString documentUrl = SimpleTextObjectView::getDocumentUrl(stateData);
    doc = AppContext::getProject()->findDocumentByURL(documentUrl);
    if (doc.isNull()) {
        stateIsIllegal = true;
        stateInfo.setError(tr("document_is_not_found %1").arg(documentUrl));
        return;
    }
    if (!doc->isLoaded()) {
        documentsToLoad.append(doc);
    }

}

void OpenSavedTextObjectViewTask::open() {
    if (stateInfo.hasErrors() || doc.isNull()) {
        return;
    }
    assert(doc->isLoaded());
    QString objName = SimpleTextObjectView::getObjectName(stateData);
    GObject* obj = doc->findGObjectByName(objName);
    TextObject* to = qobject_cast<TextObject*>(obj);
    if (!to) {
        stateInfo.setError(tr("Text object '%1' is not found").arg(objName));
        stateIsIllegal = true;
        return;
    }
    SimpleTextObjectView* v = new SimpleTextObjectView(viewName, to, stateData);
    GObjectViewWindow* w = new GObjectViewWindow(v, viewName, !stateData.isEmpty());
    MWMDIManager* mdiManager =  AppContext::getMainWindow()->getMDIManager();
    mdiManager->addMDIWindow(w);
}

void OpenSimpleTextObjectViewTask::open() {
    if (stateInfo.hasErrors() || doc.isNull()) {
        return;
    }
    assert(doc->isLoaded());
    foreach(GObject* obj, doc->findGObjectByType(GObjectTypes::TEXT)) {
        TextObject* to = qobject_cast<TextObject*>(obj);
        assert(to);
        QString viewName = GObjectViewUtils::genUniqueViewName(doc, to);
        SimpleTextObjectView* v = new SimpleTextObjectView(viewName, to, stateData);
        GObjectViewWindow* w = new GObjectViewWindow(v, viewName, !stateData.isEmpty());
        MWMDIManager* mdiManager =  AppContext::getMainWindow()->getMDIManager();
        mdiManager->addMDIWindow(w);
    }
}


//////////////////////////////////////////////////////////////////////////
// update view task

UpdateSimpleTextObjectViewTask::UpdateSimpleTextObjectViewTask(GObjectView* v, const QString& stateName, const QVariantMap& stateData) 
: ObjectViewTask(v, stateName, stateData)
{
}

void UpdateSimpleTextObjectViewTask::update() {
    if (view.isNull()) {
        return;
    }
    SimpleTextObjectView* tv = qobject_cast<SimpleTextObjectView*>(view);
    if (tv == NULL) {
        return;
    }
    tv->updateView(stateData);
    
}


} // namespace
