/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ANNOTATED_DNA_VIEW_TASKS_H_
#define _GB2_ANNOTATED_DNA_VIEW_TASKS_H_

#include <util_tasks/ObjectViewTasks.h>
#include <core_api/GObjectReference.h>

namespace GB2 {

class DNASequenceObject;
class AnnotatedDNAView;

class OpenAnnotatedDNAViewTask : public ObjectViewTask {
    Q_OBJECT
public:
	//opens a single view for all sequence object in the list of sequence objects related to the objects in the list
    OpenAnnotatedDNAViewTask(const QList<GObject*>& objects);
	
	virtual void open();

private:
	QList<GObjectReference> sequenceObjectRefs;
};

class OpenSavedAnnotatedDNAViewTask : public ObjectViewTask {
    Q_OBJECT
public:
	OpenSavedAnnotatedDNAViewTask(const QString& viewName, const QVariantMap& stateData);
	virtual void open();
	
};


class UpdateAnnotatedDNAViewTask : public ObjectViewTask {
public:
	UpdateAnnotatedDNAViewTask(AnnotatedDNAView* v, const QString& stateName, const QVariantMap& stateData);

	virtual void update();
};


} // namespace

#endif
