/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GOBJECT_COMBOBOX_CONTROLLER_H_
#define _GB2_GOBJECT_COMBOBOX_CONTROLLER_H_

#include <core_api/DocumentModel.h>
#include <core_api/GObjectReference.h>

#include <QtGui/QComboBox>

namespace GB2 {

//TODO: use custom class for objects filtering, share it with ProjectTreeController

class GObjectComboBoxControllerConstraints {
public:
    GObjectComboBoxControllerConstraints() {
        onlyWritable = false;
        uof = UOF_LoadedOnly;
    }

    GObjectType             typeFilter;
    GObjectRelation         relationFilter;
    bool                    onlyWritable;
    UnloadedObjectFilter    uof;
};

class GB2_COREAPI_EXPORT GObjectComboBoxController : public QObject {
    Q_OBJECT
public:
    GObjectComboBoxController(QObject* p, const GObjectComboBoxControllerConstraints& c, QComboBox* combo);

    bool setSelectedObject(GObject* obj) {return setSelectedObject(GObjectReference(obj));}
    bool setSelectedObject(const GObjectReference& ref);

    GObject* getSelectedObject() const;

private slots:
    void sl_onDocumentAdded(Document* d);
    void sl_onDocumentRemoved(Document* d);
    void sl_onObjectAdded(GObject* o);
    void sl_onObjectRemoved(GObject* o);
    void sl_lockedStateChanged();

private:
    void updateCombo();
    void addObject(GObject*);
    void removeObject(const GObjectReference& ref);
    void addDocumentObjects(Document* d);
    void removeDocumentObjects(Document* d);
    QString itemText(GObject* o);

    GObjectComboBoxControllerConstraints settings;
    QComboBox*          combo;
    QIcon               objectIcon;
    QIcon               unloadedObjectIcon;
};

}//namespace

#endif
