/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SWResultFilterRegistry.h"

#include <QMutexLocker>

namespace GB2 {

SWResultFilterRegistry::SWResultFilterRegistry(QObject* pOwn): 
    QObject(pOwn)
{
    registerFilter(new SWRF_EmptyFilter, tr("None"));
    registerFilter(new SWRF_WithoutIntersect, tr("Filter intersections"));
}
SWResultFilterRegistry::~SWResultFilterRegistry() {
    foreach (const NamedSWResultFilter& namedFilter, filter_list) {
		delete namedFilter.filter;
	}
}

QStringList SWResultFilterRegistry::getFiltersNames() const {
    QStringList res;
    foreach (const NamedSWResultFilter& namedFilter, filter_list) {
		res.append(namedFilter.id_filter);
	}
    return res;
}

bool SWResultFilterRegistry::registerFilter(
                                SmithWatermanResultFilter* filter, 
                                const QString& id_filter
                                ) {
    QMutexLocker locker(&mutex);
   	QList<NamedSWResultFilter>::iterator i = findFilter(id_filter);
	if (filter_list.end() != i) {	
		return false;
	}

	NamedSWResultFilter newNamedFilter;
	newNamedFilter.filter    = filter;
	newNamedFilter.id_filter = id_filter;
	filter_list.append(newNamedFilter);	
	return true;
}
SmithWatermanResultFilter* SWResultFilterRegistry::getFilterByName(
                                                const QString& id_filter) {
    SmithWatermanResultFilter* filter = 0;
	QList<NamedSWResultFilter>::iterator i = findFilter(id_filter);
	if (filter_list.end() != i) {
		filter = (*i).filter;
	}
	return filter;
}

QList<NamedSWResultFilter>::iterator 
SWResultFilterRegistry::findFilter(const QString& id_filter) {
	QList<NamedSWResultFilter>::iterator i;
	for (i = filter_list.begin(); i != filter_list.end(); ++i) {
		if ((*i).id_filter == id_filter) {
			return i;
		}
	}
	return filter_list.end();
}

bool SWResultFilterRegistry::hadRegistered(const QString& id_filter) {
    return filter_list.end() != findFilter(id_filter);
}

} // namespace
