/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _PRIMER3_TASK_H_
#define _PRIMER3_TASK_H_

#include <core_api/Task.h>
#include <gobjects/AnnotationTableObject.h>

#include "primer3_main.h"
#include "boulder_input.h"

namespace GB2 {


class Primer3Task : public Task {
    Q_OBJECT
public:    
    void run();    
    Task::ReportResult report();    
    Primer3Task(primer_args *, seq_args *);
    void cleanup();

    pair_array_t getBestPairs();
    primer_rec *getLeftPrimers();
    primer_rec *getRightPrimers();
    primer_rec *getOligos();
private:
    primer_args *pa;
    seq_args *sa;
    primers_t primers;
    pair_array_t best_pairs;
};

class Primer3ToAnnotationsTask : public Task {
    Q_OBJECT
public:
    Primer3ToAnnotationsTask( primer_args * pa_, seq_args * sa_, 
        AnnotationTableObject* aobj_, const QString & groupName_, const QString & annName_ );

protected:
    QList<Task *> onSubTaskFinished( Task* subTask );

private:
    void processResults();
    SharedAnnotationData oligoToAnnotation(const char *title, const primer_rec *o, bool complement, 
        const seq_lib seqlib, int print_lib_sim);

    primer_args * pa;
    seq_args * sa;

    AnnotationTableObject * aobj;
    QString groupName;
    QString annName;

    Primer3Task * searchTask;
};


} //namespace

#endif //_PRIMER3_TASK_H_