/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_DOC_WORKERS_H_
#define _GB2_WORKFLOW_DOC_WORKERS_H_

#include "BaseDocWorker.h"
#include "CoreLib.h"

namespace GB2 {
namespace LocalWorkflow {

class FastaReader : public LocalDocReader {
    Q_OBJECT
public:
    FastaReader(Actor* a) : LocalDocReader(a, CoreLib::FASTA_TYPESET_ID, BaseDocumentFormats::PLAIN_FASTA){}
protected:
    virtual void doc2data(Document* doc);
};

class TextReader : public LocalDocReader {
    Q_OBJECT
public:
    TextReader(Actor* a) : LocalDocReader(a, CoreLib::TEXT_TYPESET_ID, BaseDocumentFormats::PLAIN_TEXT){}
protected:
    virtual void doc2data(Document* doc);
};

class GenbankReader : public LocalDocReader {
    Q_OBJECT
public:
    GenbankReader(Actor* a) : LocalDocReader(a, CoreLib::GENBANK_TYPESET_ID, BaseDocumentFormats::PLAIN_GENBANK){}
protected:
    virtual void doc2data(Document* doc);
};

class FastaWriter : public LocalDocWriter {
    Q_OBJECT
public:
    FastaWriter(Actor* a) : LocalDocWriter(a, BaseDocumentFormats::PLAIN_FASTA){}
protected:
    virtual void data2doc(Document*, const QVariantMap&);
};

class TextWriter : public LocalDocWriter {
    Q_OBJECT
public:
    TextWriter(Actor* a) : LocalDocWriter(a, BaseDocumentFormats::PLAIN_TEXT){}
protected:
    virtual void data2doc(Document*, const QVariantMap&);
};

class GenbankWriter : public LocalDocWriter {
    Q_OBJECT
public:
    GenbankWriter(Actor* a) : LocalDocWriter(a, BaseDocumentFormats::PLAIN_GENBANK){}
protected:
    virtual void data2doc(Document*, const QVariantMap&);
};


class MSAWriter : public LocalDocWriter {
    Q_OBJECT
public:
    MSAWriter(Actor* a, const DocumentFormatId& fid) : LocalDocWriter(a, fid){}
protected:
    virtual void data2doc(Document*, const QVariantMap&);
};

class MSAReader : public LocalDocReader {
    Q_OBJECT
public:
    MSAReader (Actor* a, const DocumentFormatId& fid) : LocalDocReader(a, CoreLib::MA_TYPESET_ID, fid){}
protected:
    virtual void doc2data(Document* doc);
};

}//Workflow namespace
}//GB2 namespace

#endif

