/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _CList_H_
#define _CList_H_


template <class T> class Iter
{
public:
	Iter(const T& _data):data(_data) {};
	T data;
	Iter<T> * prev;
	Iter<T> * next;
};

template <class T> class CList	{
public:

	CList();	

	CList( const CList<T>& _CList );	

	~CList();

	bool IsEmpty() const;
	
	int GetSize() const;

	void AddEnd( const T& newData );

	void DeleteFront();

	const T& GetNext();
	
	const T& GetFront() const;

	const Iter<T>* GetIter() const;

	void SetFrontPos();

private:
	int num;
	Iter<T> * head; 
	Iter<T> * tail;
	Iter<T> * ind;

};

template <class T> 
CList<T>::CList() {
	num = 0;
}

template <class T> 
CList<T>::CList(const CList<T>& _CList) {
	num = 0;

	int len = _CList.GetSize();

	const Iter<T> * cur = _CList.GetIter();

	while (len-- > 0) {

		AddEnd(cur->data);			
		cur = cur->next;			
	}
};

template <class T> 
CList<T>::~CList() { 		
	while ( !IsEmpty() ) {			
		DeleteFront();				
	}		
}

template <class T>
const Iter<T>* CList<T>::GetIter() const
{
	return head;	
}
template <class T> 
bool CList<T>::IsEmpty() const {
	return 0 == num;
}

template <class T>
void CList<T>::SetFrontPos()
{
	ind = head;
}


template <class T>
const T& CList<T>::GetNext()
{		
 	Iter<T> * buf = ind;	
 	ind = ind->next;	
	return (buf->data);
}

template <class T>
const T& CList<T>::GetFront() const {
	return head->data;
}

template <class T>
void CList<T>::DeleteFront() {

	if ( 0 != num ) {
		if ( 1 == num ) {
			delete head;		
		} 
		else {			
			Iter<T> * buf = head->next;
			delete head;
			head = buf;
			head->prev = NULL;			
			ind = head;	
		}
		num--;
	}
}

template <class T>
int CList<T>::GetSize() const {
	return num;
}

template <class T> 
void CList<T>::AddEnd( const T& newData ) {
	if ( Iter<T> * buf = new Iter<T>(newData) ) {				
		if (0 != num) {			
			tail->next = buf;			
			buf->prev = tail;			
			tail = buf;			
		}
		else {			
			head = buf;
			tail = buf;			
		}
		
		num++; 		
		ind = head;		
	}	
}

#endif