##################################################################
# Unipro UGENE - Integrated Bioinformatics Suite
# Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
# All Rights Reserved
# 
#
#     This source code is distributed under the terms of the
#     GNU General Public License. See the files COPYING and LICENSE
#     for details.
##################################################################

# include (smith_waterman2.pri)
include (../../ugene_globals.pri)

TEMPLATE = lib
CONFIG +=qt dll thread debug_and_release 
QT += network xml script
DEFINES+= QT_DLL
INCLUDEPATH += src _tmp ../../core/src  ../../core/_tmp 


!debug_and_release|build_pass {
    CONFIG(debug, debug|release) {
        TARGET = smith_waterman2d
        DEFINES+=_DEBUG
        CONFIG +=console
        DESTDIR=../../_debug/plugins
        MOC_DIR=_tmp/moc/debug
        OBJECTS_DIR=_tmp/obj/debug
        LIBS += -L../../_debug -lcored
    }
    CONFIG(release, debug|release) {
        DEFINES+=NDEBUG
        TARGET = smith_waterman2
        DESTDIR=../../_release/plugins
        MOC_DIR=_tmp/moc/release
        OBJECTS_DIR=_tmp/obj/release
        LIBS += -L../../_release -lcore
    }
}


UI_DIR=_tmp/ui
RCC_DIR=_tmp/rcc


win32 {
    QMAKE_CXXFLAGS_WARN_ON = -W3
    QMAKE_CFLAGS_WARN_ON = -W3

    QMAKE_LFLAGS_WINDOWS += /MANIFEST:NO
    QMAKE_MSVC_PROJECT_NAME=plugin_smith_waterman2
}

#adding SSE2 gcc compiler flag if building on SSE2 capable CPU

use_sse2() {
    !win32 {
        QMAKE_CXXFLAGS += -msse2
        QMAKE_CFLAGS_DEBUG += -msse2
        QMAKE_CFLAGS_RELEASE += -msse2
    }
    DEFINES += SW2_BUILD_WITH_SSE2
}

#adding CUDA specific parameters
use_cuda() {

    LIBS += -L$$UGENE_CUDA_LIB_DIR -lcudart
    INCLUDEPATH += $$UGENE_CUDA_INC_DIR
    
    UHMMER_CUDA_LIBS += -lcudart
    UHMMER_CUDA_FILES += src/sw_kernel.cu

#workaround for nmake bug: nvcc failes with an internal error when launched from Makefile by nvcc
    win32 {
        UHMMER_CUDA_NULL_REDIRECT = > nul
    } else {
        UHMMER_CUDA_NULL_REDIRECT = 
    }
#manually convert INCLUDEPATH:
    UHMMER_CUDA_INCLUDEPATH =
    for(path, INCLUDEPATH) {
        UHMMER_CUDA_INCLUDEPATH += -I$${path}
    }
    for(path, QMAKE_INCDIR) {
        UHMMER_CUDA_INCLUDEPATH += -I$${path}
    }
#    message( $$UHMMER_CUDA_INCLUDEPATH )

    nvzz.output = $$OBJECTS_DIR/${QMAKE_FILE_BASE}$$QMAKE_EXT_OBJ
    nvzz.commands = $$UGENE_NVCC -c -I$$UGENE_CUDA_INC_DIR $$UHMMER_CUDA_INCLUDEPATH -I$$QMAKE_INCDIR_QT \
                    -L$$UGENE_CUDA_LIB_DIR $$UHMMER_CUDA_LIBS \
                    -o ${QMAKE_FILE_OUT} \
                    ${QMAKE_FILE_NAME} \
                    $$UHMMER_CUDA_NULL_REDIRECT
    nvzz.depend_command = 
    nvzz.input = UHMMER_CUDA_FILES

    QMAKE_EXTRA_COMPILERS += nvzz

    DEFINES += SW2_BUILD_WITH_CUDA
}