/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REPEAT_FINDER_TESTS_H_
#define _GB2_REPEAT_FINDER_TESTS_H_

#include "RFBase.h"

#include <core_api/LRegion.h>

#include <test_framework/xmltest/XMLTestUtils.h>
#include <test_framework/xmltest/XMLTestUtils.h>
#include <test_framework/xmltest/DocumentModelTests.h>

#include <core_api/DNAAlphabet.h>
#include <core_api/DNATranslation.h>
#include <core_api/AppContext.h>

#include <QtXml/QDomElement>

namespace GB2 {

class FindRepeatsTask;

class GTest_FindSingleSequenceRepeatsTask : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY_EXT(GTest_FindSingleSequenceRepeatsTask, "find-repeats", TaskFlags_FOSCOE);

    void prepare();
    void run();
    LRegion parseRegion(const QString& n, const QDomElement& el); 

    QString     seq;
    
    LRegion     region;
    
    int         w, c, minD, maxD;
    bool        inverted;
    bool        reflect;
    bool        filterNested;
    QStringList excludeList;

    QString     resultFile;

};

class RepeatFinderTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};


} //namespace
#endif

