/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REMOTE_REQUEST_PLUGIN_TEST_H_
#define _GB2_REMOTE_REQUEST_PLUGIN_TEST_H_

#include <test_framework/xmltest/XMLTestUtils.h>
#include <core_api/GObject.h>

#include "RemoteRequestPlugin.h"
#include "RemoteRequestTask.h"

namespace GB2 {

class GTest_RemoteRequest : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_RemoteRequest, "plugin_remote-request");
    ~GTest_RemoteRequest(){};

    void prepare();
    void cleanup();
    Task::ReportResult report();
private:
    AnnotationTableObject *ao;
    RemoteRequestTask *task;
    int minLength;
    int maxLength;
    SendSelectionStrand strand;
    Script *script;
    QString index;
    QByteArray sequence;
    QStringList expectedResults;
};

}//ns

#endif
