/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <QtGui/QColorDialog>

#include "SettingsDialog.h"

namespace GB2 {

SettingsDialog::SettingsDialog()
{
    setupUi(this);
}

void SettingsDialog::sl_setBackgroundColor()
{
    backgroundColor=QColorDialog::getColor(backgroundColor,this);
}

void SettingsDialog::sl_setSelectionColor()
{
    selectionColor=QColorDialog::getColor(selectionColor,this);
}

QColor SettingsDialog::getBackgroundColor()const
{
    return backgroundColor;
}

QColor SettingsDialog::getSelectionColor()const
{
    return selectionColor;
}

void SettingsDialog::setBackgroundColor(QColor color)
{
    this->backgroundColor=color;
}

void SettingsDialog::setSelectionColor(QColor color)
{
    this->selectionColor=color;
}

} // namespace
