/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_SETTINGS_H_
#define _GB2_WORKFLOW_SETTINGS_H_

#include <QtCore/QString>
#include <QtCore/QObject>
#include <QtGui/QFont>

#include <core_api/core_api.h>

namespace GB2 {
class Watcher : public QObject {
    Q_OBJECT
signals:
    void changed();
    friend class WorkflowSettings;
};

#define SETTINGS QString("workflowview/")

class GB2_COREAPI_EXPORT WorkflowSettings {
public:
    static bool showGrid();
    static void setShowGrid(bool v);

    static bool snap2Grid();
    static void setSnap2Grid(bool v);

    static bool monitorRun();
    static void setMonitorRun(bool v);

    static bool failFast();
    static void setFailFast(bool v);

    static QString defaultStyle();
    static void setDefaultStyle(const QString&);

    static QFont defaultFont();
    static void setDefaultFont(const QFont&);
    
    static Watcher * const watcher;
};

}//namespace

#endif
