/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "FormatUtils.h"

namespace GB2 {

QString FormatUtils::splitThousands(int num) {
	QString prefix = "";
	QString numStr = QString::number(num);
	QString result = "";
	int j = 0;
	for (int i = numStr.length(); --i >= 0; j++) {
		result = numStr.mid(i, 1) + (j > 0 && j % 3 == 0?" " : "") + result;
	}
	return result;
}

QString FormatUtils::formatNumber(int num) {
	int rem;
	if (num >= 1000 * 1000 * 1000) {
		if ((rem = num % (1000 * 1000 * 1000)) == 0) {
			return QString::number(rem) + QString("G");
		}
		if (num % (100 * 1000 * 1000) == 0) {
			return QString::number(num / (double) (1000 * 1000 * 100), 'f', 1) +
				QString("G");
		}
	} 
	if (num >= 1000 * 1000) {
		if (num % (1000 * 1000) == 0) {
			return QString::number(num / (1000 * 1000)) + QString("m");
		}
		if (num % (100 * 1000) == 0) {
			return QString::number(num / (double) (1000 * 1000), 'f', 1) +
				QString("m");
		}
	} 
	if (num >= 1000) {
		if (num % 1000 == 0) {
			return QString::number(num / 1000) + QString("k");
		}
		if (num % 100 == 0) {
			return QString::number(num / (double) 1000, 'f', 1) +
				QString("k");
		}
	}
	return QString::number(num);
}

}
