/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SEQUENCEWALKER_TESTS_H_
#define _GB2_SEQUENCEWALKER_TESTS_H_

#include <test_framework/xmltest/XMLTestUtils.h>
#include <core_api/GObject.h>
#include <QtXml/QDomElement>
#include <test_framework/xmltest/DocumentModelTests.h>
#include <util_tasks/SequenceWalkerTask.h>

namespace GB2 {

class GTest_SW_CheckRegion : public GTest, public SequenceWalkerCallback {
    Q_OBJECT
public:

    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_SW_CheckRegion, "sw-check-region");

	ReportResult report();

	void onRegion(SequenceWalkerSubtask* t,TaskStateInfo& ti) {Q_UNUSED(t); Q_UNUSED(ti);}

private:    
    int chunkSize;
    int overlap;
	int extraLen;
	LRegion region;
	bool reventNorm;
	QList<LRegion> result;
	
protected:
	
	
};

class SequenceWalkerTests {
public:
    static QList<XMLTestFactory*> createTestFactories();
};
}//namespace
#endif
