/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_SEQUENCE_OBJECT_H_
#define _GB2_DNA_SEQUENCE_OBJECT_H_

#include <core_api/GObject.h>
#include <core_api/LRegion.h>
#include <core_api/DNAAlphabet.h>
#include <datatype/DNASequence.h>

namespace GB2 {

class  GB2_COREAPI_EXPORT DNASequenceObject: public GObject {
    Q_OBJECT
public:
    DNASequenceObject(const QString& name, const DNASequence& seq, const QVariantMap& hintsMap = QVariantMap());

    const LRegion getSequenceRange() const {return seqRange;}

    const QByteArray& getSequence() const {return dnaSeq.seq;}

    DNAAlphabet* getAlphabet() const {return dnaSeq.alphabet;}

    const DNASequence& getDNASequence() const {return dnaSeq;}

    int getSequenceLen() const {return dnaSeq.length();}

    virtual GObject* clone() const;

    void setBase(int pos, char base);

    virtual bool checkConstraints(const GObjectConstraints* c) const;

protected:
    DNASequence     dnaSeq;
    LRegion         seqRange;
};

class GB2_COREAPI_EXPORT DNASequenceObjectConstraints : public GObjectConstraints   {
    Q_OBJECT
public:
    DNASequenceObjectConstraints(QObject* p = NULL);
    int exactSequenceSize;
    DNAAlphabetType alphabetType;
};


}//namespace


#endif
