/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "LogSettings.h"

#include <core_api/AppContext.h>
#include <core_api/Settings.h>

#include <QtGui/QColor>

#define SETTINGS_ROOT QString("log_settings/")

namespace GB2 {

QString LogCategories::localizedLevelNames[LogLevel_NumLevels];

void LogCategories::init() {
    localizedLevelNames[LogLevel_TRACE]   = tr("TRACE");
    localizedLevelNames[LogLevel_DETAILS] = tr("DETAILS");
    localizedLevelNames[LogLevel_INFO]    = tr("INFO");
    localizedLevelNames[LogLevel_ERROR]   = tr("ERROR");
}

LogSettings::LogSettings() {
    //created in not inited state
}

const LogCategorySettings& LogSettings::getLogCategorySettings(const QString& cName)   {
    QHash<QString, LogCategorySettings>::const_iterator it = categories.find(cName);
    if( it == categories.end()) {
        reinitCategories();
        it = categories.find(cName);
        assert(it!=categories.end());
    }
    const LogCategorySettings& cs = it.value();
    return cs;
}

void LogSettings::reinitAll() {
    Settings *s = AppContext::getSettings();

    for (int i=0;i<LogLevel_NumLevels;i++) {
        if (levelColors[i].isEmpty()) {
            levelColors[i] = QColor(Qt::black).name();
        }
    }


    showDate = s->getValue(SETTINGS_ROOT + "showDate", true).toBool();
    showLevel = s->getValue(SETTINGS_ROOT + "showLevel", true).toBool();
    showCategory = s->getValue(SETTINGS_ROOT + "showCategory", false).toBool();;

    reinitCategories();
}

void LogSettings::reinitCategories() {

    Settings *s = AppContext::getSettings();

    LogCategories::init();
    for (int i=0; i<LogLevel_NumLevels; i++) {
        activeLevelGlobalFlag[i] = s->getValue(SETTINGS_ROOT + "activeFlagLevel"+QString::number(i), i >= LogLevel_INFO).toBool();
    }

    LogServer* ls = LogServer::getInstance();
    const QList<LogCategory*>& categoryList = ls->activeCategories();
    foreach(LogCategory* c, categoryList) {
        const QString& name = c->getCategoryName();
        if (!categories.contains(name)) {
            LogCategorySettings cs;
            cs.categoryName = name;
            for (int i=0; i<LogLevel_NumLevels; i++) {
                cs.activeLevelFlag[i] = s->getValue(SETTINGS_ROOT + "categories/" + cs.categoryName + "/activeFlagLevel" + QString::number(i), activeLevelGlobalFlag[i]).toBool();
            }
            categories[name] = cs;
        }
    }
}

void LogSettings::removeCategory(const QString& name) {
    int n = categories.remove(name);
    assert(n == 1);
    Q_UNUSED(n);
}


void LogSettings::addCategory(const LogCategorySettings& newcs) {
    assert(!categories.contains(newcs.categoryName));
    categories[newcs.categoryName] = newcs;
}

void LogSettings::save() {
    Settings *s = AppContext::getSettings();

    foreach(const LogCategorySettings& cs, categories.values()) {
        for (int i=0; i < LogLevel_NumLevels; i++) {
            s->setValue(SETTINGS_ROOT + "categories/" + cs.categoryName + "/activeFlagLevel" + QString::number(i), cs.activeLevelFlag[i]);
        }
    }
    for (int i=0; i < LogLevel_NumLevels; i++) {
        s->setValue(SETTINGS_ROOT + "color" + QString::number(i), levelColors[i]);
        s->setValue(SETTINGS_ROOT + "activeFlagLevel"+QString::number(i), activeLevelGlobalFlag[i]);
    }

    s->setValue(SETTINGS_ROOT + "showDate", showDate);
    s->setValue(SETTINGS_ROOT + "showLevel", showLevel);
    s->getValue(SETTINGS_ROOT + "showCategory", showCategory);
}

bool LogSettings::operator==(const LogSettings& other) const {
    bool res = levelColors == other.levelColors
            && activeLevelGlobalFlag == other.activeLevelGlobalFlag
            && showDate == other.showDate
            && showLevel == other.showLevel
            && showCategory == other.showCategory
            && categories == other.categories;

    return res;
}


}//namespace

