/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "LRegion.h"

namespace GB2 {

static bool _registerMeta() {
    qRegisterMetaType<LRegion>("LRegion");
    qRegisterMetaTypeStreamOperators<LRegion>("GB2::LRegion");

    qRegisterMetaType<QList<LRegion> >("QList<GB2::LRegion>");
    qRegisterMetaTypeStreamOperators< QList<LRegion> >("QList<GB2::LRegion>");
    return true;
}

bool LRegion::registerMeta = _registerMeta();

QDataStream &operator<<(QDataStream &out, const LRegion &myObj) {
    out << myObj.startPos << myObj.len;
    return out;
}

QDataStream &operator>>(QDataStream &in, LRegion &myObj) {
    in >> myObj.startPos;
    in >> myObj.len;
    return in;
}


}//namespace
