/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "LogDriver.h"

#include <core_api/Timer.h>
#include <core_api/Settings.h>
#include <core_api/Task.h>
#include "TaskStatusBar.h"

#ifdef Q_OS_WIN32
#include "windows.h"
#endif
#include <stdio.h>
//#include <conio.h>
#define LOG_SETTINGS_ROOT QString("log_settings/")

namespace GB2 {

LogDriver::LogDriver() : print_to_console(true) {
    connect(LogServer::getInstance(), SIGNAL(si_message(const LogMessage&)), SLOT(sl_onMessage(const LogMessage&)));
    settings.reinitCategories();
    settings.reinitAll();
    
}

QString LogDriver::prepareText(const LogMessage& msg) const {
    QString date = settings.showDate ? "["+GTimer::createDateTime(msg.time).toString("hh:mm") + "]" : QString();
    QString category = settings.showCategory ? "["+ msg.category + "]" : QString();
    QString level = settings.showLevel ? "["+ LogCategories::getLocalizedLevelName(msg.level) +"] " : QString();
    QString spacing = date.isEmpty() && category.isEmpty() && level.isEmpty() ? QString() : QString(" ");
    QString text = date + category + level + spacing + msg.text;

    return text;
}


void LogDriver::sl_onMessage(const LogMessage& msg) {
    if (!print_to_console || !settings.activeLevelGlobalFlag[msg.level])
    {
        return;
    }
    const LogCategorySettings& s = settings.getLogCategorySettings(msg.category);
    if (!s.activeLevelFlag[msg.level]) {
        return;
    }


    if (print_to_console == true){
        //this is Hard Code
        if (msg.text.contains(QString("##teamcity"))&&(!AppContext::getSettings()->getValue("log_settings/teamcityOut",true).toBool()))
            return;
        QByteArray ba = prepareText(msg).toLocal8Bit();
        char* buf = ba.data();
    #ifdef Q_OS_WIN32
        // a bit of magic to workaround Windows console encoding issues
        CharToOemA(buf,buf);
    #endif
        if(AppContext::getSettings()->getValue(TSB_SETTINGS_ROOT + "showTaskStatusBar", true).toBool()){
            printf("                                                                               \r");//80 spaces for remove TaskStatusBar
        }
        if(!AppContext::getSettings()->getValue(LOG_SETTINGS_ROOT + "colorOut", false).toBool()){
        printf("%s \n", buf);
        }else{
#ifdef Q_OS_WIN32
            if (msg.level==LogLevel_ERROR){
                SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), FOREGROUND_INTENSITY | FOREGROUND_RED );
            }else if (msg.level==LogLevel_DETAILS){
                SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), FOREGROUND_INTENSITY | FOREGROUND_GREEN );
            }else if (msg.level==LogLevel_TRACE){
                SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), FOREGROUND_INTENSITY | FOREGROUND_BLUE );
            }
            printf("%s \n", buf);
            SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), 0x0007);
#else
            //TO DO: for MacOs release coloring function
            if (msg.level==LogLevel_ERROR){
                printf("\e[31m%s \e[0m\n", buf);
            }else if (msg.level==LogLevel_DETAILS){
                printf("\e[32m%s \e[0m\n", buf);
            }else if (msg.level==LogLevel_TRACE){
                printf("\e[34m%s \e[0m\n", buf);
            }
#endif
        }
        //if(!AppContext::getSettings()->getValue(LOG_SETTINGS_ROOT + "colorOut", false).toBool()){
    }
}

}//namespace

