/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DocumentFormatRegistryImpl.h"
#include <document_format/PlainTextFormat.h>
#include <document_format/FastaFormat.h>
#include <document_format/GenbankPlainTextFormat.h>
#include <document_format/EMBLPlainTextFormat.h>
#include <document_format/ABIFormat.h>
#include <document_format/SCFFormat.h>
#include <document_format/RawDNASequenceFormat.h>
#include <document_format/ClustalWAlnFormat.h>
#include <document_format/StockholmFormat.h>
#include <document_format/NewickFormat.h>
#include <document_format/PDBFormat.h>


namespace GB2 {

bool DocumentFormatRegistryImpl::registerFormat(DocumentFormat* f) {
	assert(getFormatById(f->getFormatId())==NULL);
	formats.push_back(f);
	emit si_documentFormatRegistered(f);
	return true;
}

QList<DocumentFormatId> DocumentFormatRegistryImpl::getRegisteredFormats() const {
	QList<DocumentFormatId> ids;
	foreach(DocumentFormat* df, formats) {
		ids.append(df->getFormatId());
	}
	return ids;
}

QList<DocumentFormatId> DocumentFormatRegistryImpl::selectFormats(const DocumentFormatConstraints& c) const {
	QList<DocumentFormatId> ids;
	foreach(DocumentFormat* df, formats) {
		if (df->checkConstraints(c)) {
			ids.append(df->getFormatId());
		}
	}
	return ids;
}

bool DocumentFormatRegistryImpl::unregisterFormat(DocumentFormat* f) {
	int n = formats.removeAll(f);
	bool res = n > 0;
	if (res) {
		emit si_documentFormatUnregistered(f);
	}
	return res;
}

DocumentFormat* DocumentFormatRegistryImpl::getFormatById(DocumentFormatId id) const {
	foreach (DocumentFormat* f, formats) {
		if (f->getFormatId() == id) {
			return f;
		}
	}
	return NULL;
}

void DocumentFormatRegistryImpl::init() {
	PlainTextFormat* text = new PlainTextFormat(this);
	registerFormat(text);	

	FastaFormat* fasta = new FastaFormat(this);
	registerFormat(fasta);	

	GenbankPlainTextFormat* gb = new GenbankPlainTextFormat(this);
	registerFormat(gb);

    EMBLPlainTextFormat* em = new EMBLPlainTextFormat(this);
    registerFormat(em);

    ABIFormat* abi = new ABIFormat(this);
    registerFormat(abi);

    SCFFormat* scf = new SCFFormat(this);
    registerFormat(scf);

    RawDNASequenceFormat* rsf = new RawDNASequenceFormat(this);
    registerFormat(rsf);

    ClustalWAlnFormat* aln = new ClustalWAlnFormat(this);
    registerFormat(aln);

    StockholmFormat* stf = new StockholmFormat(this);
    registerFormat(stf);

    NewickFormat* nwf = new NewickFormat(this);
    registerFormat(nwf);
    
    PDBFormat* pdb = new PDBFormat(this);
    registerFormat(pdb);



}

}//namespace
