/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef ScoreHistory_h
#define ScoreHistory_h

class ScoreHistory
	{
public:
	ScoreHistory(unsigned uIters, unsigned uInternalNodeCount);
	~ScoreHistory();
	bool SetScore(unsigned uIter, unsigned uInternalNodeIndex, bool bRight, SCORE Score);
	void LogMe() const;
	SCORE GetScore(unsigned uIter, unsigned uInternalNodeIndex, bool bReversed,
	  bool bRight) const;

private:
	SCORE **m_Score;
	bool **m_bScoreSet;
	unsigned m_uIters;
	unsigned m_uNodeCount;
	};

#endif	// ScoreHistory_h
