/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "muscle.h"

#define GAPVAL		0.3
#define GAPGAPVAL	5.0

// Blosum62 log-average factor matrix
static float Blosum62LA[20][20] =
	{
#define v(x)	((float) x)
#define S_ROW(n, c, A, C, D, E, F, G, H, I, K, L, M, N, P, Q, R, S, T, V, W, Y) \
	{ v(A), v(C), v(D), v(E), v(F), v(G), v(H), v(I), v(K), v(L), v(M), v(N), v(P), v(Q), \
	v(R), v(S), v(T), v(V), v(W), v(Y) },

// Blosum62	log	average matrix
//				A			C			D			E			F
//				G			H			I			K			L
//				M			N			P			Q			R
//				S			T			V			W			Y
S_ROW( 0, 'A',  3.9029401,  0.8679881,  0.5446049,  0.7412640,  0.4648942, 
                1.0568696,  0.5693654,  0.6324813,  0.7753898,  0.6019460, 
                0.7231498,  0.5883077,  0.7541214,  0.7568035,  0.6126988, 
                1.4721037,  0.9844022,  0.9364584,  0.4165484,  0.5426125)

S_ROW( 1, 'C',  0.8679881, 19.5765802,  0.3014542,  0.2859347,  0.4389910, 
                0.4203886,  0.3550472,  0.6534589,  0.3491296,  0.6422760, 
                0.6113537,  0.3978026,  0.3795628,  0.3657796,  0.3089379, 
                0.7384148,  0.7405530,  0.7558448,  0.4499807,  0.4342013)

S_ROW( 2, 'D',  0.5446049,  0.3014542,  7.3979253,  1.6878109,  0.2989696, 
                0.6343015,  0.6785593,  0.3390155,  0.7840905,  0.2866128, 
                0.3464547,  1.5538520,  0.5987177,  0.8970811,  0.5732000, 
                0.9135051,  0.6947898,  0.3365004,  0.2321050,  0.3456829)

S_ROW( 3, 'E',  0.7412640,  0.2859347,  1.6878109,  5.4695276,  0.3307441, 
                0.4812675,  0.9600400,  0.3305223,  1.3082782,  0.3728734, 
                0.5003421,  0.9112983,  0.6792027,  1.9017376,  0.9607983, 
                0.9503570,  0.7414260,  0.4289431,  0.3743021,  0.4964664)

S_ROW( 4, 'F',  0.4648942,  0.4389910,  0.2989696,  0.3307441,  8.1287983, 
                0.3406407,  0.6519893,  0.9457698,  0.3440433,  1.1545978, 
                1.0043715,  0.3542882,  0.2874440,  0.3339729,  0.3807263, 
                0.4399736,  0.4816930,  0.7450894,  1.3743775,  2.7693817)

S_ROW( 5, 'G',  1.0568696,  0.4203886,  0.6343015,  0.4812675,  0.3406407, 
                6.8763075,  0.4929663,  0.2750096,  0.5888716,  0.2845039, 
                0.3954865,  0.8637114,  0.4773858,  0.5386498,  0.4499840, 
                0.9035965,  0.5792712,  0.3369551,  0.4216898,  0.3487141)

S_ROW( 6, 'H',  0.5693654,  0.3550472,  0.6785593,  0.9600400,  0.6519893, 
                0.4929663, 13.5060070,  0.3262878,  0.7788884,  0.3806759, 
                0.5841316,  1.2220028,  0.4728797,  1.1679835,  0.9170473, 
                0.7367319,  0.5575021,  0.3394474,  0.4440859,  1.7979036)

S_ROW( 7, 'I',  0.6324813,  0.6534589,  0.3390155,  0.3305223,  0.9457698, 
                0.2750096,  0.3262878,  3.9979299,  0.3963730,  1.6944349, 
                1.4777449,  0.3279345,  0.3846629,  0.3829375,  0.3547509, 
                0.4431634,  0.7798163,  2.4175121,  0.4088732,  0.6303898)

S_ROW( 8, 'K',  0.7753898,  0.3491296,  0.7840905,  1.3082782,  0.3440433, 
                0.5888716,  0.7788884,  0.3963730,  4.7643359,  0.4282702, 
                0.6253033,  0.9398419,  0.7037741,  1.5543233,  2.0768092, 
                0.9319192,  0.7929060,  0.4565429,  0.3589319,  0.5321784)

S_ROW( 9, 'L',  0.6019460,  0.6422760,  0.2866128,  0.3728734,  1.1545978, 
                0.2845039,  0.3806759,  1.6944349,  0.4282702,  3.7966214, 
                1.9942957,  0.3100430,  0.3711219,  0.4773261,  0.4739194, 
                0.4288939,  0.6603292,  1.3142355,  0.5680359,  0.6920589)

S_ROW(10, 'M',  0.7231498,  0.6113537,  0.3464547,  0.5003421,  1.0043715, 
                0.3954865,  0.5841316,  1.4777449,  0.6253033,  1.9942957, 
                6.4814549,  0.4745299,  0.4238960,  0.8642486,  0.6226249, 
                0.5985578,  0.7938018,  1.2689365,  0.6103022,  0.7083636)

S_ROW(11, 'N',  0.5883077,  0.3978026,  1.5538520,  0.9112983,  0.3542882, 
                0.8637114,  1.2220028,  0.3279345,  0.9398419,  0.3100430, 
                0.4745299,  7.0940964,  0.4999337,  1.0005835,  0.8586298, 
                1.2315289,  0.9841525,  0.3690340,  0.2777841,  0.4860309)

S_ROW(12, 'P',  0.7541214,  0.3795628,  0.5987177,  0.6792027,  0.2874440, 
                0.4773858,  0.4728797,  0.3846629,  0.7037741,  0.3711219, 
                0.4238960,  0.4999337, 12.8375452,  0.6412803,  0.4815348, 
                0.7555033,  0.6888962,  0.4430825,  0.2818321,  0.3635216)

S_ROW(13, 'Q',  0.7568035,  0.3657796,  0.8970811,  1.9017376,  0.3339729, 
                0.5386498,  1.1679835,  0.3829375,  1.5543233,  0.4773261, 
                0.8642486,  1.0005835,  0.6412803,  6.2444210,  1.4057958, 
                0.9655559,  0.7913219,  0.4667781,  0.5093584,  0.6110951)

S_ROW(14, 'R',  0.6126988,  0.3089379,  0.5732000,  0.9607983,  0.3807263, 
                0.4499840,  0.9170473,  0.3547509,  2.0768092,  0.4739194, 
                0.6226249,  0.8586298,  0.4815348,  1.4057958,  6.6655769, 
                0.7671661,  0.6777544,  0.4200721,  0.3951049,  0.5559652)

S_ROW(15, 'S',  1.4721037,  0.7384148,  0.9135051,  0.9503570,  0.4399736, 
                0.9035965,  0.7367319,  0.4431634,  0.9319192,  0.4288939, 
                0.5985578,  1.2315289,  0.7555033,  0.9655559,  0.7671661, 
                3.8428476,  1.6139205,  0.5652240,  0.3853031,  0.5575206)

S_ROW(16, 'T',  0.9844022,  0.7405530,  0.6947898,  0.7414260,  0.4816930, 
                0.5792712,  0.5575021,  0.7798163,  0.7929060,  0.6603292, 
                0.7938018,  0.9841525,  0.6888962,  0.7913219,  0.6777544, 
                1.6139205,  4.8321048,  0.9809432,  0.4309317,  0.5731577)

S_ROW(17, 'V',  0.9364584,  0.7558448,  0.3365004,  0.4289431,  0.7450894, 
                0.3369551,  0.3394474,  2.4175121,  0.4565429,  1.3142355, 
                1.2689365,  0.3690340,  0.4430825,  0.4667781,  0.4200721, 
                0.5652240,  0.9809432,  3.6921553,  0.3744576,  0.6580390)

S_ROW(18, 'W',  0.4165484,  0.4499807,  0.2321050,  0.3743021,  1.3743775, 
                0.4216898,  0.4440859,  0.4088732,  0.3589319,  0.5680359, 
                0.6103022,  0.2777841,  0.2818321,  0.5093584,  0.3951049, 
                0.3853031,  0.4309317,  0.3744576, 38.1077830,  2.1098056)

S_ROW(19, 'Y',  0.5426125,  0.4342013,  0.3456829,  0.4964664,  2.7693817, 
                0.3487141,  1.7979036,  0.6303898,  0.5321784,  0.6920589, 
                0.7083636,  0.4860309,  0.3635216,  0.6110951,  0.5559652, 
                0.5575206,  0.5731577,  0.6580390,  2.1098056,  9.8322054)
	};
