/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "TaskLocalStorage.h"
#include "muscle/muscle.h"
#include "muscle/objscore.h"
#include "muscle/profile.h"
#include "muscle/enumopts.h"
#include "muscle/params.h"
#include "muscle/muscle_context.h"

class MuscleContext *getMuscleContext() {
    return GB2::TaskLocalData::current();
}

namespace GB2 {

QThreadStorage<MuscleContextTLSRef*> TaskLocalData::tls;

class MuscleContext* TaskLocalData::current(){
    MuscleContextTLSRef* ref = tls.localData();
    if (ref!=NULL) {
        assert(ref->ctx!=NULL);
        return ref->ctx;
    }
    assert(0);
    return NULL;
}

void TaskLocalData::initializeMuscleTLSContext() {
    assert(!tls.hasLocalData());//TODO: won't work if thread pools used!
    tls.setLocalData(new MuscleContextTLSRef(new MuscleContext()));
}

void TaskLocalData::freeMuscleTLSContext() {
    MuscleContextTLSRef* ref = tls.localData();
    assert(ref!=NULL && ref->ctx!=NULL);
    delete ref->ctx;
    ref->ctx = NULL;
    tls.setLocalData(NULL);
}

}//namespace

