/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_UHMM_SEARCH_H_
#define _GB2_UHMM_SEARCH_H_

#include <core_api/LRegion.h>
#include <QtCore/QObject>
#include <float.h>

struct plan7_s;

namespace GB2 {

class TaskStateInfo;

class UHMMSearchSettings {
public:
    UHMMSearchSettings() : globE(10), eValueNSeqs(1),  searchChunkSize(1000000), 
        overlapSize(0), exOverlapSize(0), nThreads(1), domE(0.9999999),  domT(-FLT_MAX) {}

    float   globE;
    int     eValueNSeqs;
    int		searchChunkSize;
    int		overlapSize;
    int		exOverlapSize;
    int		nThreads;
    float	domE;
    float	domT;
};

class UHMMSearchResult {
public:
    UHMMSearchResult(const LRegion& _r, float sc, float eval) : r(_r), score(sc), evalue(eval){}
    LRegion r;
    float   score;
    float   evalue;
};

class UHMMSearch : public QObject {
    Q_OBJECT

public:
    static QList<UHMMSearchResult> search(plan7_s* hmm, const char* seq, int seqLen, const UHMMSearchSettings& s, TaskStateInfo& si);

};

} //namespace

#endif
