/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_UHMM_CALIBRATE_H_
#define _GB2_UHMM_CALIBRATE_H_

struct plan7_s;
struct alphabet_s;
struct histogram_s;
#include <QMutex>
#include <QSemaphore>

namespace GB2 {

class TaskStateInfo;


class UHMMCalibrateSettings {
public:
    UHMMCalibrateSettings();

    int     nsample;      // number of random seqs to sample
    int     seed;         // random number seed             
    int     fixedlen;     // fixed length, or 0 if unused
    float   lenmean;      // mean of length distribution
    float   lensd;        // std dev of length distribution 
	int		nThreads;

};
struct WorkPool_s {
  /* Static configuration:
   */
  plan7_s  *hmm;		/* ptr to single HMM to search with    */
  int    fixedlen;		/* if >0, fix random seq len to this   */
  float  lenmean;		/* mean of Gaussian for random seq len */
  float  lensd;			/* s.d. of Gaussian for random seq len */
  float *randomseq;             /* 0..Alphabet_size-1 i.i.d. probs     */
  int    nsample;		/* number of random seqs to do         */
  alphabet_s *al;

  /* Shared (mutex-protected) input:
   */
  int    nseq;			/* current number of seqs searched     */

  /* Shared (mutex-protected) output:
   */
  histogram_s *hist;     /* histogram          */
  float          max_score;     /* maximum score seen */
//  Stopwatch_t    watch;		/* Timings accumulated for threads */

  /* Thread pool information:
   */
  QMutex lockInput;
  QMutex lockOutput;
  QSemaphore sem;  
  
  int *progress;
};

class UHMMCalibrate {
public:
    static void calibrate(plan7_s* hmm, const UHMMCalibrateSettings& s, TaskStateInfo& si);
	static void calibrateParallelWorker(WorkPool_s *wpool, TaskStateInfo& si);

};

}//namespace


#endif

