/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_HMMCALIBRATE_DIALOG_CONTROLLER_H_
#define _GB2_HMMCALIBRATE_DIALOG_CONTROLLER_H_

#include "uhmmcalibrate.h"
#include <core_api/Task.h>
#include <ui/ui_HMMCalibrateDialog.h>
#include <hmmer2/funcs.h>


#include <QThreadStorage>
#include <QSemaphore>
#include <QtGui/QDialog>

namespace GB2 {

class IOAdapterFactory;
class HMMCalibrateParallelSubTask;
class HMMCalibrateAbstractTask;
class HMMReadTask;

class HMMCalibrateDialogController : public QDialog, public Ui_HMMCalibrateDialog {
    Q_OBJECT

public:
    HMMCalibrateDialogController(QWidget* w = NULL);

public slots:
    virtual void reject();

private slots:
    void sl_hmmFileButtonClicked();
    void sl_outFileButtonClicked();
    void sl_okButtonClicked();

    void sl_onStateChanged();
    void sl_onProgressChanged();

private:
    Task* task;
};

class HMMCalibrateToFileTask : public Task {
    Q_OBJECT
public:
    HMMCalibrateToFileTask(const QString& _inFile, const QString& _outFile, const UHMMCalibrateSettings& s);
    
    const plan7_s* getHMM() const {return hmm;}
    virtual void prepare();
    virtual QList<Task*> onSubTaskFinished(Task* subTask);
    QString generateReport() const;

protected:
    plan7_s*                    hmm;
    QString                     inFile;
    QString                     outFile;
    UHMMCalibrateSettings       settings;
    HMMReadTask*                readTask;
    HMMCalibrateAbstractTask*   calibrateTask;
};

class HMMCalibrateAbstractTask : public Task {
    Q_OBJECT
public:
	HMMCalibrateAbstractTask(const QString& _name, plan7_s* _hmm, const UHMMCalibrateSettings& s)
		:Task(_name, TaskFlag_DeleteWhenFinished), hmm(_hmm), settings(s)
	{}
	plan7_s* getHMM(){return hmm;}

protected:
	plan7_s*    hmm;
    UHMMCalibrateSettings settings;
};

class HMMCalibrateTask : public HMMCalibrateAbstractTask {
    Q_OBJECT
public:
    HMMCalibrateTask(plan7_s* hmm, const UHMMCalibrateSettings& s);
    void run();
    void _run();
};

class HMMCalibrateParallelTask : public HMMCalibrateAbstractTask {
    Q_OBJECT
public:
    HMMCalibrateParallelTask(plan7_s* hmm, const UHMMCalibrateSettings& s);
	
	void run();
    void _run();

	static HMMERTaskLocalData *getTLS();

private:
	QList<Task*> onSubTaskFinished(Task* subTask);
	QList<HMMCalibrateParallelSubTask*> calibrateSubtasks;
	IOAdapterFactory* iof;
	WorkPool_s *wpool;
	histogram_s *hist;
	QSemaphore subtaskWaitSem;  
};

class HMMCalibrateParallelSubTask : public Task {
    Q_OBJECT
public:
    HMMCalibrateParallelSubTask(WorkPool_s *wpool);
    
    void run();
    void _run();

private:
	WorkPool_s *wpool;
};

} //namespace

#endif

