/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_UHMM_BUILD_H_
#define _GB2_UHMM_BUILD_H_

struct plan7_s;
struct msa_struct;

#include <QtCore/QString>
#include <QtCore/QObject>

namespace GB2 {

class TaskStateInfo;

// algorithm configuration strategy

enum HMMBuildStrategy {
    P7_BASE_CONFIG, // hmmbuild -g
    P7_LS_CONFIG,   // hmmbuild <no options>
    P7_FS_CONFIG,   // hmmbuild -f
    P7_SW_CONFIG    // hmmbuild -s
};

class UHMMBuildSettings {
public:
    UHMMBuildSettings() : strategy(P7_LS_CONFIG){};

    HMMBuildStrategy    strategy;
    QString             name; //name of the hmm
};

class UHMMBuild : public QObject {
    Q_OBJECT

public:
    static plan7_s* build(msa_struct* msa, int atype, const UHMMBuildSettings& s, TaskStateInfo& si);

};

}//namespace


#endif

